/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.directive.include;

import java.io.IOException;
import java.io.Reader;
import org.commontemplate.config.LineDirectiveHandler;
import org.commontemplate.core.Context;
import org.commontemplate.standard.operator.collection.LiteralList;
import org.commontemplate.util.Assert;

public class DisplayFileDirectiveHandler
extends LineDirectiveHandler {
    private static final long serialVersionUID = 1L;

    public void doInterpret(String string, Object object, Context context) throws Exception {
        if (object instanceof String) {
            this.readFile(context, (String)object);
        } else if (object instanceof LiteralList) {
            LiteralList literalList = (LiteralList)object;
            if (literalList.size() == 1 && literalList.get(0) instanceof String) {
                this.readFile(context, (String)literalList.get(0));
            } else if (literalList.size() == 2 && literalList.get(0) instanceof String && literalList.get(1) instanceof String) {
                this.readFile(context, (String)literalList.get(0), (String)literalList.get(1));
            } else {
                Assert.fail("display\u53c2\u6570\u5217\u8868\u9519\u8bef!");
            }
        } else {
            Assert.fail("display\u53c2\u6570\u5217\u8868\u9519\u8bef!");
        }
    }

    private void readFile(Context context, String string) throws IOException {
        this.read(context, context.loadResource(string).getReader());
    }

    private void readFile(Context context, String string, String string2) throws IOException {
        this.read(context, context.loadResource(string, string2).getReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(Context context, Reader reader) throws IOException {
        try {
            int n;
            char[] cArray = new char[1024];
            while (-1 != (n = reader.read(cArray))) {
                context.output(new String(cArray, 0, n));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

