/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.directive;

import java.util.Map;
import org.commontemplate.config.BlockDirectiveHandler;
import org.commontemplate.config.DirectiveHandler;
import org.commontemplate.config.DirectiveHandlerProvider;
import org.commontemplate.config.LineDirectiveHandler;

public class StandardDirectiveHandlerProvider
implements DirectiveHandlerProvider {
    private Map directiveHandlers;
    private LineDirectiveHandler defaultLineDirectiveHandler;
    private BlockDirectiveHandler defaultBlockDirectiveHandler;
    private String defaultBlockDirectiveRegex = ".*_block";

    public void setDirectiveHandlers(Map map) {
        this.directiveHandlers = map;
    }

    public void setDefaultLineDirectiveHandler(LineDirectiveHandler lineDirectiveHandler) {
        this.defaultLineDirectiveHandler = lineDirectiveHandler;
    }

    public void setDefaultBlockDirectiveHandler(BlockDirectiveHandler blockDirectiveHandler) {
        this.defaultBlockDirectiveHandler = blockDirectiveHandler;
    }

    public void setDefaultBlockDirectiveRegex(String string) {
        this.defaultBlockDirectiveRegex = string;
    }

    public DirectiveHandler getDirectiveHandler(String string) {
        DirectiveHandler directiveHandler = (DirectiveHandler)this.directiveHandlers.get(string);
        if (directiveHandler != null) {
            return directiveHandler;
        }
        if (string != null && string.length() > 0 && string.matches(this.defaultBlockDirectiveRegex)) {
            return this.defaultBlockDirectiveHandler;
        }
        return this.defaultLineDirectiveHandler;
    }
}

