/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.coat;

import java.util.List;
import org.commontemplate.config.Syntax;
import org.commontemplate.util.LinkedStack;
import org.commontemplate.util.scanner.Token;

class TagTranslator {
    private static final String attribute = "\\s+ct\\:(if|for|out|message)\\=\\\"([^\\\"]*)\\\"";
    private static final String matchesAttribute = ".*\\s+ct\\:(if|for|out|message)\\=\\\"([^\\\"]*)\\\".*";
    private static final String moveAttribute = "(.*)\\s+ct\\:(if|for|out|message)\\=\\\"([^\\\"]*)\\\"(.*)";
    private Syntax syntax;

    public TagTranslator(Syntax syntax) {
        this.syntax = syntax;
    }

    public String translate(List list) {
        LinkedStack linkedStack = new LinkedStack();
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Token token = (Token)list.get(i);
            String string = token.getMessage();
            if (string.charAt(0) == '<' && string.charAt(1) != '!') {
                int n2;
                String string2;
                if (string.charAt(1) == '/') {
                    string2 = string.substring(2, string.length() - 1);
                    CountEntry countEntry = (CountEntry)linkedStack.pop();
                    while (!string2.trim().equalsIgnoreCase(countEntry.getName())) {
                        countEntry = (CountEntry)linkedStack.pop();
                    }
                    if (countEntry.getCount() > 0) {
                        for (n2 = 0; n2 < countEntry.getCount(); ++n2) {
                            string = string + this.syntax.getLeader() + this.syntax.getEndDirectiveName() + this.syntax.getExpressionBegin() + this.syntax.getExpressionEnd();
                        }
                    }
                } else {
                    string2 = string.substring(1, this.firstSpace(string));
                    boolean bl = string.charAt(string.length() - 2) == '/';
                    n2 = 0;
                    while (string.matches(matchesAttribute)) {
                        ++n2;
                        string = string.replaceFirst(moveAttribute, this.syntax.getLeader() + "$2" + this.syntax.getExpressionBegin() + "$3" + this.syntax.getExpressionEnd() + "$1$4");
                    }
                    if (bl) {
                        for (int j = 0; j < n2; ++j) {
                            string = string + this.syntax.getLeader() + this.syntax.getEndDirectiveName() + this.syntax.getExpressionBegin() + this.syntax.getExpressionEnd();
                        }
                    } else {
                        linkedStack.push(new CountEntry(string2.trim().toLowerCase(), n2));
                    }
                }
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int firstSpace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            return i;
        }
        return string.length() - 1;
    }

    private static final class CountEntry {
        private String name;
        private int count;

        public CountEntry(String string, int n) {
            this.name = string;
            this.count = n;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return this.name + ":" + this.count;
        }
    }
}

