/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.commontemplate.config.Cache;
import org.commontemplate.config.CacheException;

public class WeakCache
implements Cache {
    private final Map cacheMap = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object get(Object object) throws CacheException {
        this.processQueue();
        WeakValueReference weakValueReference = (WeakValueReference)this.cacheMap.get(object);
        return weakValueReference == null ? null : weakValueReference.get();
    }

    public void put(Object object, Object object2) throws CacheException {
        this.processQueue();
        this.cacheMap.put(object, new WeakValueReference(object, object2, this.queue));
    }

    public void remove(Object object) throws CacheException {
        this.processQueue();
        this.cacheMap.remove(object);
    }

    public void clear() throws CacheException {
        this.cacheMap.clear();
        this.processQueue();
    }

    private void processQueue() {
        WeakValueReference weakValueReference;
        while ((weakValueReference = (WeakValueReference)this.queue.poll()) != null) {
            Object object = weakValueReference.getKey();
            if (this.cacheMap.get(object) != weakValueReference) continue;
            this.cacheMap.remove(object);
        }
        return;
    }

    private static final class WeakValueReference
    extends WeakReference {
        private final Object key;

        WeakValueReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        Object getKey() {
            return this.key;
        }
    }
}

