/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.commontemplate.config.Cache;
import org.commontemplate.config.CacheException;

public class SoftCache
implements Cache {
    private final Map cacheMap = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object get(Object object) throws CacheException {
        this.processQueue();
        SoftValueReference softValueReference = (SoftValueReference)this.cacheMap.get(object);
        return softValueReference == null ? null : softValueReference.get();
    }

    public void put(Object object, Object object2) throws CacheException {
        this.processQueue();
        this.cacheMap.put(object, new SoftValueReference(object, object2, this.queue));
    }

    public void remove(Object object) throws CacheException {
        this.processQueue();
        this.cacheMap.remove(object);
    }

    public void clear() throws CacheException {
        this.cacheMap.clear();
        this.processQueue();
    }

    private void processQueue() {
        SoftValueReference softValueReference;
        while ((softValueReference = (SoftValueReference)this.queue.poll()) != null) {
            Object object = softValueReference.getKey();
            if (this.cacheMap.get(object) != softValueReference) continue;
            this.cacheMap.remove(object);
        }
        return;
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        Object getKey() {
            return this.key;
        }
    }
}

