/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.commontemplate.config.Cache;
import org.commontemplate.config.CacheException;
import org.commontemplate.util.Assert;

public class OSCache
implements Cache {
    private static final String GROUP = "CommonTemplateCache";
    private final com.opensymphony.oscache.base.Cache cache;
    private int refreshPeriod = -1;

    public OSCache() {
        GeneralCacheAdministrator generalCacheAdministrator = new GeneralCacheAdministrator();
        this.cache = generalCacheAdministrator.getCache();
        Assert.assertNotNull(this.cache, "\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58!");
    }

    public void setRefreshPeriod(int n) {
        Assert.assertTrue(n > 0, "refreshPeriod \u5fc5\u9700\u5927\u4e8e0\uff01");
        this.refreshPeriod = n;
    }

    public Object get(Object object) throws CacheException {
        try {
            return this.refreshPeriod > 0 ? this.cache.getFromCache(String.valueOf(object), this.refreshPeriod) : this.cache.getFromCache(String.valueOf(object));
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.cache.cancelUpdate(String.valueOf(object));
            return null;
        }
    }

    public void put(Object object, Object object2) throws CacheException {
        this.cache.putInCache(String.valueOf(object), object2, new String[]{GROUP});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) throws CacheException {
        try {
            this.cache.flushEntry(String.valueOf(object));
        }
        finally {
            this.cache.cancelUpdate(String.valueOf(object));
        }
    }

    public void clear() throws CacheException {
        this.cache.flushGroup(GROUP);
    }
}

