/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.cache;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.commontemplate.config.Cache;
import org.commontemplate.config.CacheException;
import org.commontemplate.util.Assert;

public class FifoCache
implements Cache {
    private final Map cacheMap = new HashMap();
    private final LinkedList keyList = new LinkedList();
    private int maxSize = 100;

    public void setMaxSize(int n) {
        Assert.assertTrue(n > 0);
        this.maxSize = n;
    }

    public void put(Object object, Object object2) throws CacheException {
        this.cacheMap.put(object, object2);
        this.keyList.add(object);
        if (this.keyList.size() > this.maxSize) {
            try {
                Object e = this.keyList.removeFirst();
                this.cacheMap.remove(e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public Object get(Object object) throws CacheException {
        return this.cacheMap.get(object);
    }

    public void remove(Object object) throws CacheException {
        this.cacheMap.remove(object);
        this.keyList.remove(object);
    }

    public void clear() throws CacheException {
        this.cacheMap.clear();
        this.keyList.clear();
    }

    public String toString() {
        return "FifoCache: " + this.maxSize;
    }
}

