/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.commontemplate.config.Cache;
import org.commontemplate.config.CacheException;
import org.commontemplate.util.Assert;

public class DiskSerialCache
implements Cache {
    private String root;
    private String directory;
    private String prefix;
    private String suffix;
    private Cache memoryCache;
    private String replacer;
    private static final String DEFAULT_REPLACER = "_-";

    public void setRootDirectory(String string) {
        this.root = this.filterDirectory(string);
    }

    public void setDirectory(String string) {
        this.directory = this.filterDirectory(string);
    }

    private String filterDirectory(String string) {
        char c;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() > 0 && (c = string.charAt(string.length() - 1)) != '/' && c != '\\') {
            return string + '/';
        }
        return string;
    }

    private File getDirectory() {
        String string = this.directory;
        if (this.root != null) {
            string = this.root + string;
        }
        Assert.assertNotEmpty(string, "\u7f13\u5b58\u5b58\u50a8\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
        File file = new File(string);
        if (file.exists() && !file.isDirectory() && !file.delete()) {
            throw new RuntimeException("\u5220\u9664\u6587\u4ef6\uff1a" + string + " \u5931\u8d25\uff01");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5939\uff1a" + string + " \u5931\u8d25\uff01");
        }
        return file;
    }

    public void setFilePrefix(String string) {
        this.prefix = string;
    }

    public void setFileSuffix(String string) {
        this.suffix = string;
    }

    public void setMemoryCache(Cache cache) {
        Assert.assertNotNull(cache, "\u5185\u5b58\u7f13\u5b58\u4e3a\u7a7a!");
        this.memoryCache = cache;
    }

    public void setPathSeparatorReplacer(String string) {
        this.replacer = string;
    }

    private File getCacheFile(Object object) {
        String string = String.valueOf(object);
        if (this.prefix != null) {
            string = this.prefix + string;
        }
        if (this.suffix != null) {
            string = string + this.suffix;
        }
        return new File(this.getDirectory(), this.replacePath(string));
    }

    private String replacePath(String string) {
        String string2 = this.replacer;
        if (string2 == null) {
            string2 = DEFAULT_REPLACER;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == '\\') {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Object get(Object object) throws CacheException {
        Object object2 = this.memoryCache.get(object);
        if (object2 != null) {
            return object2;
        }
        try {
            File file = this.getCacheFile(object);
            if (!file.exists()) {
                return null;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            Object object3 = objectInputStream.readObject();
            if (object3 == null) {
                return null;
            }
            this.memoryCache.put(object, object3);
            return object3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new CacheException(object, (Throwable)iOException);
        }
        catch (Exception exception) {
            throw new CacheException(object, (Throwable)exception);
        }
    }

    public void put(Object object, Object object2) throws CacheException {
        this.memoryCache.put(object, object2);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.getCacheFile(object)));
            objectOutputStream.writeObject(object2);
        }
        catch (Exception exception) {
            throw new CacheException(object, (Throwable)exception);
        }
    }

    public void remove(Object object) throws CacheException {
        File file = this.getCacheFile(object);
        if (file.exists() && !file.delete()) {
            throw new CacheException((Object)("\u5220\u9664\u6587\u4ef6\uff1a" + file.getPath() + " \u5931\u8d25\uff01"));
        }
    }

    public void clear() throws CacheException {
        File[] fileArray = this.getDirectory().listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (fileArray[i].delete()) continue;
            throw new CacheException((Object)("\u5220\u9664\u6587\u4ef6\uff1a" + fileArray[i].getPath() + " \u5931\u8d25\uff01"));
        }
    }
}

