/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.commontemplate.config.BinaryOperatorHandler;
import org.commontemplate.config.BlockDirectiveHandler;
import org.commontemplate.config.Cache;
import org.commontemplate.config.Configuration;
import org.commontemplate.config.ConfigurationException;
import org.commontemplate.config.DirectiveHandlerProvider;
import org.commontemplate.config.Keywords;
import org.commontemplate.config.LineDirectiveHandler;
import org.commontemplate.config.OperatorHandlerProvider;
import org.commontemplate.config.ReloadController;
import org.commontemplate.config.ResourceBundleProvider;
import org.commontemplate.config.ResourceComparator;
import org.commontemplate.config.Syntax;
import org.commontemplate.config.TemplateNameFilter;
import org.commontemplate.config.TemplateReaderFilter;
import org.commontemplate.config.TextBlockFilter;
import org.commontemplate.config.UnaryOperatorHandler;
import org.commontemplate.core.EventListener;
import org.commontemplate.core.Logger;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.ResourceLoader;
import org.commontemplate.standard.cache.EHCache;
import org.commontemplate.standard.cache.FifoCache;
import org.commontemplate.standard.cache.LruCache;
import org.commontemplate.standard.cache.MruCache;
import org.commontemplate.standard.cache.NoneCache;
import org.commontemplate.standard.cache.OSCache;
import org.commontemplate.standard.cache.SoftCache;
import org.commontemplate.standard.cache.StrongCache;
import org.commontemplate.standard.cache.WeakCache;
import org.commontemplate.standard.directive.StandardDirectiveHandlerProvider;
import org.commontemplate.standard.filter.TemplateNameFilterChain;
import org.commontemplate.standard.filter.TemplateReaderFilterChain;
import org.commontemplate.standard.filter.TextBlockFilterChain;
import org.commontemplate.standard.format.DateFormatter;
import org.commontemplate.standard.format.NullFormatter;
import org.commontemplate.standard.format.NumberFormatter;
import org.commontemplate.standard.format.OutputFormatterChain;
import org.commontemplate.standard.i18n.PropertiesResourceBundleProvider;
import org.commontemplate.standard.listener.EventListenerChain;
import org.commontemplate.standard.log.CommonsLogging;
import org.commontemplate.standard.operator.BinaryOperatorHandlerChainItem;
import org.commontemplate.standard.operator.StandardOperatorHandlerProvider;
import org.commontemplate.standard.operator.UnaryOperatorHandlerChainItem;
import org.commontemplate.standard.reload.IntervalReloadController;
import org.commontemplate.util.Assert;
import org.commontemplate.util.TypeUtils;

public class StandardConfiguration
extends Configuration {
    private boolean debugMode;
    private boolean functionAvailable;
    private Logger logger;
    private Cache templateCache;
    private ResourceBundleProvider resourceBundleProvider;
    private ResourceLoader resourceLoader;
    private List templateReaderFilters = new ArrayList();
    private List templateNameFilters = new ArrayList();
    private Map typeFormatters = new HashMap();
    private OutputFormatter nullFormatter;
    private OutputFormatter generalFormatter;
    private ReloadController reloadController;
    private ResourceComparator resourceComparator;
    private List textBlockFilters = new ArrayList();
    private Syntax syntax = Syntax.DEFAULT;
    private Keywords expressionKeywords = Keywords.DEFAULT;
    private Map directiveHandlers = new HashMap();
    private Map binaryOperatorPrioritys = new HashMap();
    private Map unaryOperatorPrioritys = new HashMap();
    private int functionPriority = 0;
    private Map binaryOperatorHandlers = new HashMap();
    private Map lastBinaryOperators = new HashMap();
    private Map unaryOperatorHandlers = new HashMap();
    private Map lastUnaryOperators = new HashMap();
    private List eventListeners = new ArrayList();
    private List asynchronousEventListeners = new ArrayList();
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;

    public void setModificationCheckInterval(long l) {
        IntervalReloadController intervalReloadController = new IntervalReloadController();
        intervalReloadController.setModificationCheckInterval(l);
        this.setReloadController(intervalReloadController);
    }

    public void setMessageBasename(String string) {
        PropertiesResourceBundleProvider propertiesResourceBundleProvider = new PropertiesResourceBundleProvider();
        propertiesResourceBundleProvider.setBasename(string);
        this.setResourceBundleProvider(propertiesResourceBundleProvider);
    }

    public void setStandardCache(String string, int n) {
        if (string == null || "NONE".equalsIgnoreCase(string)) {
            this.setTemplateCache(new NoneCache());
        } else if ("STRONG".equalsIgnoreCase(string)) {
            this.setTemplateCache(new StrongCache());
        } else if ("SOFT".equalsIgnoreCase(string)) {
            this.setTemplateCache(new SoftCache());
        } else if ("WEAK".equalsIgnoreCase(string)) {
            this.setTemplateCache(new WeakCache());
        } else if ("FIFO".equalsIgnoreCase(string)) {
            FifoCache fifoCache = new FifoCache();
            fifoCache.setMaxSize(n);
            this.setTemplateCache(fifoCache);
        } else if ("LRU".equalsIgnoreCase(string)) {
            LruCache lruCache = new LruCache();
            lruCache.setMaxSize(n);
            this.setTemplateCache(lruCache);
        } else if ("MRU".equalsIgnoreCase(string)) {
            MruCache mruCache = new MruCache();
            mruCache.setMaxSize(n);
            this.setTemplateCache(mruCache);
        } else if ("OSCACHE".equalsIgnoreCase(string)) {
            this.setTemplateCache(new OSCache());
        } else if ("EHCACHE".equalsIgnoreCase(string)) {
            this.setTemplateCache(new EHCache());
        }
    }

    public void setDefaultNumberFormat(String string) {
        this.addDefaultOutputFormatter(class$java$lang$Number == null ? (class$java$lang$Number = StandardConfiguration.class$("java.lang.Number")) : class$java$lang$Number, new NumberFormatter(string));
    }

    public void setDefaultDateFormat(String string) {
        this.addDefaultOutputFormatter(class$java$util$Date == null ? (class$java$util$Date = StandardConfiguration.class$("java.util.Date")) : class$java$util$Date, new DateFormatter(string));
    }

    public void setDefaultNullValue(String string) {
        this.addDefaultOutputFormatter(null, new NullFormatter(string));
    }

    public void setCommonsLogging() {
        this.setLogger(new CommonsLogging());
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public boolean isFunctionAvailable() {
        return this.functionAvailable;
    }

    public void setFunctionAvailable(boolean bl) {
        this.functionAvailable = bl;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Cache getTemplateCache() {
        return this.templateCache;
    }

    public void setTemplateCache(Cache cache) {
        this.templateCache = cache;
    }

    public ResourceBundleProvider getResourceBundleProvider() {
        return this.resourceBundleProvider;
    }

    public void setResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.resourceBundleProvider = resourceBundleProvider;
    }

    public void setMessageBaseName(String string) {
        PropertiesResourceBundleProvider propertiesResourceBundleProvider = new PropertiesResourceBundleProvider();
        propertiesResourceBundleProvider.setBasename(string);
        this.setResourceBundleProvider(propertiesResourceBundleProvider);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List getTemplateReaderFilters() {
        return this.templateReaderFilters;
    }

    public void setTemplateReaderFilters(List list) {
        this.templateReaderFilters.addAll(list);
    }

    public void addTemplateReaderFilter(TemplateReaderFilter templateReaderFilter) {
        this.templateReaderFilters.add(templateReaderFilter);
    }

    public void removeTemplateReaderFilter(TemplateReaderFilter templateReaderFilter) {
        this.templateReaderFilters.remove(templateReaderFilter);
    }

    public TemplateReaderFilter getTemplateReaderFilter() {
        TemplateReaderFilterChain templateReaderFilterChain = new TemplateReaderFilterChain();
        templateReaderFilterChain.setTemplateReaderFilters(this.getTemplateReaderFilters());
        return templateReaderFilterChain;
    }

    public List getTemplateNameFilters() {
        return this.templateNameFilters;
    }

    public void setTemplateNameFilters(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addTemplateNameFilter((TemplateNameFilter)iterator.next());
        }
    }

    public void addTemplateNameFilter(TemplateNameFilter templateNameFilter) {
        this.templateNameFilters.add(templateNameFilter);
    }

    public void removeTemplateNameFilter(TemplateNameFilter templateNameFilter) {
        this.templateNameFilters.remove(templateNameFilter);
    }

    public TemplateNameFilter getTemplateNameFilter() {
        TemplateNameFilterChain templateNameFilterChain = new TemplateNameFilterChain();
        templateNameFilterChain.setTemplateNameFilters(this.getTemplateNameFilters());
        return templateNameFilterChain;
    }

    public void addDefaultOutputFormatter(Class clazz, OutputFormatter outputFormatter) {
        if (clazz == null) {
            this.nullFormatter = outputFormatter;
        } else {
            this.typeFormatters.put(clazz, outputFormatter);
        }
    }

    public void removeDefaultOutputFormatter(Class clazz) {
        if (clazz == null) {
            this.nullFormatter = null;
        } else {
            this.typeFormatters.remove(clazz);
        }
    }

    public void setDefaultOutputFormatter(OutputFormatter outputFormatter) {
        this.generalFormatter = outputFormatter;
    }

    public OutputFormatter getDefaultOutputFormatter() {
        OutputFormatterChain outputFormatterChain = new OutputFormatterChain();
        outputFormatterChain.setGeneralFormatter(this.generalFormatter);
        outputFormatterChain.setNullFormatter(this.nullFormatter);
        outputFormatterChain.setTypeFormatters(this.typeFormatters);
        return outputFormatterChain;
    }

    public ReloadController getReloadController() {
        return this.reloadController;
    }

    public void setReloadController(ReloadController reloadController) {
        this.reloadController = reloadController;
    }

    public ResourceComparator getResourceComparator() {
        return this.resourceComparator;
    }

    public void setResourceComparator(ResourceComparator resourceComparator) {
        if (resourceComparator == null) {
            throw new ConfigurationException("\u4e0d\u80fd\u8bbe\u7f6e\u7a7a\u7684resourceComparator\uff01");
        }
        this.resourceComparator = resourceComparator;
    }

    public List getTextBlockFilters() {
        return this.textBlockFilters;
    }

    public void setTextBlockFilters(List list) {
        this.textBlockFilters = list;
    }

    public void addTextBlockFilter(TextBlockFilter textBlockFilter) {
        this.textBlockFilters.add(textBlockFilter);
    }

    public void removeTextBlockFilter(TextBlockFilter textBlockFilter) {
        this.textBlockFilters.remove(textBlockFilter);
    }

    public TextBlockFilter getTextBlockFilter() {
        TextBlockFilterChain textBlockFilterChain = new TextBlockFilterChain();
        textBlockFilterChain.setTextBlockFilters(this.getTextBlockFilters());
        return textBlockFilterChain;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        Assert.assertNotNull(syntax, "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u7a7a\u8bed\u6cd5!");
        this.syntax = syntax;
    }

    public Keywords getKeywords() {
        return this.expressionKeywords;
    }

    public void setKeywords(Keywords keywords) {
        this.expressionKeywords = keywords;
    }

    public Map getDirectiveHandlers() {
        return this.directiveHandlers;
    }

    public void setDirectiveHandlers(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof BlockDirectiveHandler) {
                this.addDirectiveHandler((String)entry.getKey(), (BlockDirectiveHandler)entry.getValue());
                continue;
            }
            this.addDirectiveHandler((String)entry.getKey(), (LineDirectiveHandler)entry.getValue());
        }
    }

    public void addDirectiveHandler(String string, BlockDirectiveHandler blockDirectiveHandler) {
        if (blockDirectiveHandler == null) {
            throw new ConfigurationException("\u6307\u4ee4\u5904\u7406\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (string == null) {
            string = "";
        }
        if (!"".equals(string) && !TypeUtils.isNamed(string)) {
            throw new ConfigurationException("\u4e0d\u5408\u6cd5\u7684\u6307\u4ee4\u540d\u79f0:" + string);
        }
        this.directiveHandlers.put(string.trim(), blockDirectiveHandler);
    }

    public void addDirectiveHandler(String string, LineDirectiveHandler lineDirectiveHandler) {
        if (lineDirectiveHandler == null) {
            throw new ConfigurationException("\u6307\u4ee4\u5904\u7406\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (string == null) {
            string = "";
        }
        if (!"".equals(string) && !TypeUtils.isNamed(string)) {
            throw new ConfigurationException("\u4e0d\u5408\u6cd5\u7684\u6307\u4ee4\u540d\u79f0:" + string);
        }
        this.directiveHandlers.put(string.trim(), lineDirectiveHandler);
    }

    public DirectiveHandlerProvider getDirectiveHandlerProvider() {
        StandardDirectiveHandlerProvider standardDirectiveHandlerProvider = new StandardDirectiveHandlerProvider();
        standardDirectiveHandlerProvider.setDirectiveHandlers(this.getDirectiveHandlers());
        return standardDirectiveHandlerProvider;
    }

    public Map getBinaryOperatorPrioritys() {
        return this.binaryOperatorPrioritys;
    }

    public void setBinaryOperatorPrioritys(Map map) {
        this.binaryOperatorPrioritys.putAll(map);
    }

    public void addBinaryOperatorPriority(String string, int n) {
        this.binaryOperatorPrioritys.put(string, new Integer(n));
    }

    public void removeBinaryOperatorPriority(String string) {
        this.binaryOperatorPrioritys.remove(string);
    }

    public Map getUnaryOperatorPrioritys() {
        return this.unaryOperatorPrioritys;
    }

    public void setUnaryOperatorPrioritys(Map map) {
        this.unaryOperatorPrioritys.putAll(map);
    }

    public void addUnaryOperatorPriority(String string, int n) {
        this.unaryOperatorPrioritys.put(string, new Integer(n));
    }

    public void removeUnaryOperatorPriority(String string) {
        this.unaryOperatorPrioritys.remove(string);
    }

    public final void setFunctionPriority(int n) {
        this.functionPriority = n;
    }

    public int getFunctionPriority() {
        return this.functionPriority;
    }

    public Map getBinaryOperatorHandlers() {
        return this.binaryOperatorHandlers;
    }

    public void setBinaryOperatorHandlers(Map map) {
        this.binaryOperatorHandlers.putAll(map);
    }

    public void addBinaryOperatorHandler(String string, BinaryOperatorHandler binaryOperatorHandler) {
        this.binaryOperatorHandlers.put(string, binaryOperatorHandler);
    }

    public void removeBinaryOperatorHandler(String string) {
        this.binaryOperatorHandlers.remove(string);
    }

    public void addBinaryOperatorHandlerChain(String string, BinaryOperatorHandlerChainItem binaryOperatorHandlerChainItem) {
        BinaryOperatorHandlerChainItem binaryOperatorHandlerChainItem2;
        if (!this.getBinaryOperatorHandlers().containsKey(string)) {
            this.addBinaryOperatorHandler(string, binaryOperatorHandlerChainItem);
        }
        if ((binaryOperatorHandlerChainItem2 = (BinaryOperatorHandlerChainItem)this.lastBinaryOperators.get(string)) != null) {
            binaryOperatorHandlerChainItem2.setNextHandler(binaryOperatorHandlerChainItem);
        }
        this.lastBinaryOperators.put(string, binaryOperatorHandlerChainItem);
    }

    public Map getUnaryOperatorHandlers() {
        return this.unaryOperatorHandlers;
    }

    public void setUnaryOperatorHandlers(Map map) {
        this.unaryOperatorHandlers.putAll(map);
    }

    public void addUnaryOperatorHandler(String string, UnaryOperatorHandler unaryOperatorHandler) {
        this.unaryOperatorHandlers.put(string, unaryOperatorHandler);
    }

    public void removeUnaryOperatorHandler(String string) {
        this.unaryOperatorHandlers.remove(string);
    }

    public void addUnaryOperatorHandlerChain(String string, UnaryOperatorHandlerChainItem unaryOperatorHandlerChainItem) {
        UnaryOperatorHandlerChainItem unaryOperatorHandlerChainItem2;
        if (!this.getUnaryOperatorHandlers().containsKey(string)) {
            this.addUnaryOperatorHandler(string, unaryOperatorHandlerChainItem);
        }
        if ((unaryOperatorHandlerChainItem2 = (UnaryOperatorHandlerChainItem)this.lastUnaryOperators.get(string)) != null) {
            unaryOperatorHandlerChainItem2.setNextHandler(unaryOperatorHandlerChainItem);
        }
        this.lastUnaryOperators.put(string, unaryOperatorHandlerChainItem);
    }

    public OperatorHandlerProvider getOperatorHandlerProvider() {
        StandardOperatorHandlerProvider standardOperatorHandlerProvider = new StandardOperatorHandlerProvider();
        standardOperatorHandlerProvider.setBinaryOperatorHandlers(this.getBinaryOperatorHandlers());
        standardOperatorHandlerProvider.setBinaryOperatorPrioritys(this.getBinaryOperatorPrioritys());
        standardOperatorHandlerProvider.setUnaryOperatorHandlers(this.getUnaryOperatorHandlers());
        standardOperatorHandlerProvider.setUnaryOperatorPrioritys(this.getUnaryOperatorPrioritys());
        standardOperatorHandlerProvider.setFunctionPriority(this.getFunctionPriority());
        return standardOperatorHandlerProvider;
    }

    public List getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List list) {
        this.eventListeners = list;
    }

    public void addEventListener(EventListener eventListener) {
        Assert.assertNotNull(eventListener, "\u4e0d\u80fd\u6dfb\u52a0\u7a7a\u7684EventListener");
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public List getAsynchronousEventListeners() {
        return this.asynchronousEventListeners;
    }

    public void setAsynchronousEventListeners(List list) {
        this.asynchronousEventListeners = list;
    }

    public void addAsynchronousEventListener(EventListener eventListener) {
        Assert.assertNotNull(eventListener, "\u4e0d\u80fd\u6dfb\u52a0\u7a7a\u7684\u5f02\u6b65EventListener");
        this.asynchronousEventListeners.add(eventListener);
    }

    public void removeAsynchronousEventListener(EventListener eventListener) {
        this.asynchronousEventListeners.remove(eventListener);
    }

    public EventListener getEventListener() {
        EventListenerChain eventListenerChain = new EventListenerChain();
        eventListenerChain.setEventListeners(this.getEventListeners());
        eventListenerChain.setAsynchronousEventListeners(this.getAsynchronousEventListeners());
        return eventListenerChain;
    }

    public void validate() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

