/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard;

import org.commontemplate.config.Cache;
import org.commontemplate.config.Configuration;
import org.commontemplate.config.ConfigurationException;
import org.commontemplate.config.DirectiveHandlerProvider;
import org.commontemplate.config.Keywords;
import org.commontemplate.config.OperatorHandlerProvider;
import org.commontemplate.config.ReloadController;
import org.commontemplate.config.ResourceBundleProvider;
import org.commontemplate.config.ResourceComparator;
import org.commontemplate.config.Syntax;
import org.commontemplate.config.TemplateNameFilter;
import org.commontemplate.config.TemplateReaderFilter;
import org.commontemplate.config.TextBlockFilter;
import org.commontemplate.core.EventListener;
import org.commontemplate.core.Logger;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.ResourceLoader;
import org.commontemplate.util.Assert;

public class ConfigurationSettings
extends Configuration {
    private boolean functionAvailable;
    private Keywords expressionKeywords = Keywords.DEFAULT;
    private OperatorHandlerProvider operatorHandlerProvider;
    private TextBlockFilter textBlockFilter;
    private Syntax syntax = Syntax.DEFAULT;
    private DirectiveHandlerProvider directiveHandlerProvider;
    private boolean debugMode;
    private Logger logger;
    private Cache templateCache;
    private ResourceBundleProvider resourceBundleProvider;
    private ResourceLoader resourceLoader;
    private TemplateReaderFilter templateReaderFilter;
    private TemplateNameFilter templateNameFilter;
    private OutputFormatter defaultOutputFormatter;
    private ReloadController reloadController;
    private ResourceComparator resourceComparator;
    private EventListener eventListener;

    public boolean isFunctionAvailable() {
        return this.functionAvailable;
    }

    public void setFunctionAvailable(boolean bl) {
        this.functionAvailable = bl;
    }

    public Keywords getKeywords() {
        return this.expressionKeywords;
    }

    public void setKeywordsSetting(String string) {
        Assert.assertTrue(string != null && string.trim().length() > 0, "ExpressionKeywordsString\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String[] stringArray = string.trim().split("\\,");
        String string2 = stringArray.length > 0 ? stringArray[0] : "null";
        String string3 = stringArray.length > 1 ? stringArray[1] : "false";
        String string4 = stringArray.length > 2 ? stringArray[2] : "true";
        String string5 = stringArray.length > 3 ? stringArray[3] : "this";
        String string6 = stringArray.length > 4 ? stringArray[4] : "super";
        String string7 = stringArray.length > 5 ? stringArray[5] : "context";
        this.setKeywords(new Keywords(string2, string3, string4, string5, string6, string7));
    }

    public void setKeywords(Keywords keywords) {
        this.expressionKeywords = keywords;
    }

    public OperatorHandlerProvider getOperatorHandlerProvider() {
        return this.operatorHandlerProvider;
    }

    public void setOperatorHandlerProvider(OperatorHandlerProvider operatorHandlerProvider) {
        this.operatorHandlerProvider = operatorHandlerProvider;
    }

    public TextBlockFilter getTextBlockFilter() {
        return this.textBlockFilter;
    }

    public void setTextBlockFilter(TextBlockFilter textBlockFilter) {
        this.textBlockFilter = textBlockFilter;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        Assert.assertNotNull(syntax, "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u7a7a\u8bed\u6cd5!");
        this.syntax = syntax;
    }

    public void setSyntaxSetting(String string) {
        Assert.assertTrue(string != null && string.trim().length() > 0, "DirectiveSyntaxString\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        string = string.trim();
        char c = string.length() > 0 ? (char)string.charAt(0) : (char)'$';
        char c2 = string.length() > 1 ? (char)string.charAt(1) : (char)'{';
        char c3 = string.length() > 2 ? (char)string.charAt(2) : (char)'}';
        char c4 = string.length() > 3 ? (char)string.charAt(3) : (char)'#';
        char c5 = string.length() > 4 ? (char)string.charAt(4) : (char)'*';
        char c6 = string.length() > 5 ? (char)string.charAt(5) : (char)'!';
        String string2 = string.length() > 6 ? string.substring(6) : "end";
        this.setSyntax(new Syntax(c, c2, c3, c4, c5, c6, string2));
    }

    public DirectiveHandlerProvider getDirectiveHandlerProvider() {
        return this.directiveHandlerProvider;
    }

    public void setDirectiveHandlerProvider(DirectiveHandlerProvider directiveHandlerProvider) {
        this.directiveHandlerProvider = directiveHandlerProvider;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Cache getTemplateCache() {
        return this.templateCache;
    }

    public void setTemplateCache(Cache cache) {
        this.templateCache = cache;
    }

    public ResourceBundleProvider getResourceBundleProvider() {
        return this.resourceBundleProvider;
    }

    public void setResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.resourceBundleProvider = resourceBundleProvider;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public TemplateReaderFilter getTemplateReaderFilter() {
        return this.templateReaderFilter;
    }

    public void setTemplateReaderFilter(TemplateReaderFilter templateReaderFilter) {
        this.templateReaderFilter = templateReaderFilter;
    }

    public TemplateNameFilter getTemplateNameFilter() {
        return this.templateNameFilter;
    }

    public void setTemplateNameFilter(TemplateNameFilter templateNameFilter) {
        this.templateNameFilter = templateNameFilter;
    }

    public OutputFormatter getDefaultOutputFormatter() {
        return this.defaultOutputFormatter;
    }

    public void setDefaultOutputFormatter(OutputFormatter outputFormatter) {
        this.defaultOutputFormatter = outputFormatter;
    }

    public ReloadController getReloadController() {
        return this.reloadController;
    }

    public void setReloadController(ReloadController reloadController) {
        this.reloadController = reloadController;
    }

    public ResourceComparator getResourceComparator() {
        return this.resourceComparator;
    }

    public void setResourceComparator(ResourceComparator resourceComparator) {
        if (resourceComparator == null) {
            throw new ConfigurationException("\u4e0d\u80fd\u8bbe\u7f6e\u7a7a\u7684resourceComparator\uff01");
        }
        this.resourceComparator = resourceComparator;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void validate() {
    }
}

