/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.template;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import org.commontemplate.core.BlockDirective;
import org.commontemplate.core.Context;
import org.commontemplate.core.InterpretationException;
import org.commontemplate.core.RenderingException;
import org.commontemplate.core.Resource;
import org.commontemplate.core.Template;
import org.commontemplate.core.Visitor;
import org.commontemplate.util.Assert;
import org.commontemplate.util.IOUtils;

final class TemplateImpl
extends Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BlockDirective rootDirective;
    private final String name;
    private final String encoding;
    private final long lastModified;
    private final char[] data;

    TemplateImpl(Resource resource, BlockDirective blockDirective) throws IOException {
        Assert.assertNotNull(resource, "resource == null");
        Assert.assertNotNull(blockDirective, "rootDirective == null");
        this.name = resource.getName();
        this.encoding = resource.getEncoding();
        this.lastModified = resource.getLastModified();
        this.data = IOUtils.readToChars(resource.getReader());
        this.rootDirective = blockDirective;
    }

    public final List getRootDirectives() {
        return this.rootDirective.getInnerDirectives();
    }

    public final void render(Context context) throws RenderingException {
        context.pushTemplate(this);
        try {
            this.rootDirective.interpret(context);
        }
        catch (InterpretationException interpretationException) {
            throw new RenderingException((Template)this, context, interpretationException.getDirective().getLocation(), (Throwable)interpretationException);
        }
        finally {
            context.popTemplate();
        }
    }

    public final void accept(Visitor visitor) {
        visitor.visit(this);
        this.rootDirective.accept(visitor);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final String getName() {
        return this.name;
    }

    public final Reader getReader() throws IOException {
        return new CharArrayReader(this.data);
    }
}

