/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.template;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.commontemplate.config.TemplateConfiguration;
import org.commontemplate.config.TemplateReaderFilter;
import org.commontemplate.core.BlockDirective;
import org.commontemplate.core.Expression;
import org.commontemplate.core.ExpressionParser;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.Resource;
import org.commontemplate.core.Template;
import org.commontemplate.core.TemplateParser;
import org.commontemplate.engine.expression.ExpressionEngine;
import org.commontemplate.engine.template.DirectiveFactory;
import org.commontemplate.engine.template.DirectiveReducer;
import org.commontemplate.engine.template.DirectiveTokenizer;
import org.commontemplate.engine.template.DirectiveTranslator;
import org.commontemplate.engine.template.TemplateImpl;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Location;
import org.commontemplate.util.scanner.ScanningException;

public final class TemplateEngine
implements TemplateParser {
    private final ExpressionParser expressionParser;
    private final DirectiveTokenizer directiveTokenizer;
    private final DirectiveTranslator directiveTranslator;
    private final DirectiveReducer directiveReducer;
    private final TemplateReaderFilter templateReaderFilter;

    public TemplateEngine(TemplateConfiguration templateConfiguration) {
        Assert.assertNotNull(templateConfiguration, "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        this.expressionParser = new ExpressionEngine(templateConfiguration);
        this.directiveTokenizer = new DirectiveTokenizer(templateConfiguration.getSyntax());
        this.directiveTranslator = new DirectiveTranslator(new DirectiveFactory(templateConfiguration.getSyntax(), templateConfiguration.getDirectiveHandlerProvider(), this.expressionParser, templateConfiguration.getTextBlockFilter()));
        this.directiveReducer = new DirectiveReducer();
        this.templateReaderFilter = templateConfiguration.getTemplateReaderFilter();
    }

    private final BlockDirective parseDirective(Reader reader) throws IOException, ParsingException {
        try {
            List list = this.directiveTokenizer.split(reader);
            List list2 = this.directiveTranslator.translate(list);
            BlockDirective blockDirective = this.directiveReducer.reduce(list2);
            return blockDirective;
        }
        catch (ParsingException parsingException) {
            throw parsingException;
        }
        catch (ScanningException scanningException) {
            throw new ParsingException(new Location(scanningException.getOffset().getPosition(), scanningException.getOffset().getPosition()), (Throwable)scanningException);
        }
    }

    public final Expression parseExpression(String string) throws ParsingException {
        try {
            return this.expressionParser.parseExpression(string);
        }
        catch (ParsingException parsingException) {
            throw new ParsingException((Resource)new StringResource(string), parsingException.getLocation(), (Throwable)parsingException);
        }
    }

    public final Template parseTemplate(Resource resource) throws ParsingException, IOException {
        Reader reader = resource.getReader();
        if (this.templateReaderFilter != null) {
            reader = this.templateReaderFilter.filter(reader);
        }
        try {
            return new TemplateImpl(resource, this.parseDirective(reader));
        }
        catch (ParsingException parsingException) {
            throw new ParsingException(resource, parsingException.getLocation(), (Throwable)parsingException);
        }
    }

    public final Template parseTemplate(String string) throws ParsingException {
        Assert.assertNotNull(string, "\u4e0d\u80fd\u89e3\u6790\u7a7a\u6a21\u677f!");
        StringResource stringResource = new StringResource(string);
        try {
            return this.parseTemplate(stringResource);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static final class StringResource
    extends Resource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String template;

        StringResource(String string) {
            this.template = string;
        }

        public final String getEncoding() {
            return "UTF-8";
        }

        public final long getLastModified() {
            return -1L;
        }

        public final String getName() {
            return "";
        }

        public final Reader getReader() throws IOException {
            return new StringReader(this.template);
        }
    }
}

