/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.template;

import org.commontemplate.config.BlockDirectiveHandler;
import org.commontemplate.core.Context;
import org.commontemplate.core.Directive;
import org.commontemplate.core.Expression;
import org.commontemplate.core.InterpretationException;
import org.commontemplate.core.Visitor;
import org.commontemplate.core.event.InterpretationBeginningEvent;
import org.commontemplate.core.event.InterpretationEndedEvent;
import org.commontemplate.engine.template.Relatible;
import org.commontemplate.util.Location;

class StartDirective
extends Relatible {
    private static final long serialVersionUID = 1L;
    private final Expression expression;
    private final String name;
    private final Location location;
    private final String prototype;
    private final BlockDirectiveHandler startDirectiveHandler;
    private final String endPrototype;

    StartDirective(String string, Location location, Expression expression, BlockDirectiveHandler blockDirectiveHandler, String string2, String string3) {
        this.name = string;
        this.prototype = string2;
        this.location = location;
        this.expression = expression;
        this.startDirectiveHandler = blockDirectiveHandler;
        this.endPrototype = string3;
    }

    public final void interpret(Context context) throws InterpretationException {
        context.publishEvent(new InterpretationBeginningEvent(this));
        context.pushLocalContext();
        try {
            Expression expression = this.getExpression();
            Object object = expression == null ? null : expression.evaluate(context);
            this.startDirectiveHandler.doInterpret(this.getName(), object, this.getInnerDirectives(), context);
        }
        catch (InterpretationException interpretationException) {
            throw interpretationException;
        }
        catch (Exception exception) {
            throw new InterpretationException((Directive)this, (Throwable)exception);
        }
        finally {
            context.popLocalContext();
            context.publishEvent(new InterpretationEndedEvent(this));
        }
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getCanonicalForm() {
        return this.prototype + this.getCanonicalFormAll() + this.endPrototype;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.acceptExpression(visitor);
        this.acceptAll(visitor);
    }
}

