/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.template;

import org.commontemplate.config.LineDirectiveHandler;
import org.commontemplate.core.Context;
import org.commontemplate.core.Directive;
import org.commontemplate.core.Expression;
import org.commontemplate.core.InterpretationException;
import org.commontemplate.core.Visitor;
import org.commontemplate.core.event.InterpretationBeginningEvent;
import org.commontemplate.core.event.InterpretationEndedEvent;
import org.commontemplate.util.Location;

final class LineDirective
extends Directive {
    private static final long serialVersionUID = 1L;
    private final Expression expression;
    private final String name;
    private final Location location;
    private final String prototype;
    private final LineDirectiveHandler directiveHandler;

    LineDirective(String string, Location location, Expression expression, LineDirectiveHandler lineDirectiveHandler, String string2) {
        this.name = string;
        this.prototype = string2;
        this.location = location;
        this.expression = expression;
        this.directiveHandler = lineDirectiveHandler;
    }

    public final void interpret(Context context) throws InterpretationException {
        context.publishEvent(new InterpretationBeginningEvent(this));
        try {
            Expression expression = this.getExpression();
            Object object = expression == null ? null : expression.evaluate(context);
            this.directiveHandler.doInterpret(this.getName(), object, context);
        }
        catch (InterpretationException interpretationException) {
            throw interpretationException;
        }
        catch (Exception exception) {
            throw new InterpretationException((Directive)this, (Throwable)exception);
        }
        context.publishEvent(new InterpretationEndedEvent(this));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        Expression expression = this.getExpression();
        if (expression != null) {
            expression.accept(visitor);
        }
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getCanonicalForm() {
        return this.prototype;
    }
}

