/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.template;

import org.commontemplate.config.BlockDirectiveHandler;
import org.commontemplate.config.DirectiveHandler;
import org.commontemplate.config.DirectiveHandlerProvider;
import org.commontemplate.config.LineDirectiveHandler;
import org.commontemplate.config.MiddleBlockDirectiveHandler;
import org.commontemplate.config.Syntax;
import org.commontemplate.config.TextBlockFilter;
import org.commontemplate.core.Directive;
import org.commontemplate.core.Expression;
import org.commontemplate.core.ExpressionParser;
import org.commontemplate.core.ParsingException;
import org.commontemplate.engine.template.CommentDirective;
import org.commontemplate.engine.template.EndDirective;
import org.commontemplate.engine.template.LineDirective;
import org.commontemplate.engine.template.MiddleDirective;
import org.commontemplate.engine.template.StartDirective;
import org.commontemplate.engine.template.TextDirective;
import org.commontemplate.util.Assert;
import org.commontemplate.util.scanner.Token;

final class DirectiveFactory {
    private final Syntax syntax;
    private final DirectiveHandlerProvider directiveHandlerProvider;
    private final ExpressionParser expressionParser;
    private final TextBlockFilter textFilter;

    DirectiveFactory(Syntax syntax, DirectiveHandlerProvider directiveHandlerProvider, ExpressionParser expressionParser, TextBlockFilter textBlockFilter) {
        this.syntax = syntax;
        this.directiveHandlerProvider = directiveHandlerProvider;
        this.expressionParser = expressionParser;
        this.textFilter = textBlockFilter;
    }

    Directive getDirective(Token token, boolean bl) throws ParsingException {
        String string = token.getMessage();
        String string2 = string.trim();
        if (string2.length() > 1 && string2.charAt(0) == this.syntax.getLeader()) {
            if (string2.charAt(1) == this.syntax.getNoParse()) {
                return this.parseText(String.valueOf(this.syntax.getNoParse()), token, string.substring(2, string.length() - 2));
            }
            if (string2.charAt(1) == this.syntax.getLineComment()) {
                if (string2.length() > 2 && string2.charAt(2) == this.syntax.getLineComment()) {
                    return new CommentDirective(String.valueOf(this.syntax.getLineComment()), token.getLocation(), string.substring(3), string2);
                }
                return null;
            }
            if (string2.charAt(1) == this.syntax.getBlockComment()) {
                if (string2.length() > 2 && string2.charAt(2) == this.syntax.getBlockComment()) {
                    return new CommentDirective(String.valueOf(this.syntax.getBlockComment()), token.getLocation(), string.substring(3, string.length() - 2), string2);
                }
                return null;
            }
            return this.parseDirective(token, string2);
        }
        return this.parseText("text", token, this.cleanEscape(string, bl));
    }

    private Directive parseText(String string, Token token, String string2) {
        if (this.textFilter != null) {
            string2 = this.textFilter.filter(string2);
        }
        return new TextDirective(string, token.getLocation(), string2, token.getMessage());
    }

    String cleanEscape(String string, boolean bl) {
        if (string == null || string.length() < 2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (string.charAt(i) == this.syntax.getLeader() || !bl && i == n - 1 && c == '\\') {
                int n2 = this.countLastSlash(stringBuffer);
                Assert.assertTrue(n2 % 2 != 0, "\u8bed\u6cd5\u89e3\u6790\u9519\u8bef!");
                int n3 = (n2 - 1) / 2 + 1;
                stringBuffer.delete(stringBuffer.length() - n3, stringBuffer.length());
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    int countLastSlash(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return 0;
        }
        int n = 0;
        for (int i = stringBuffer.length() - 1; i >= 0 && stringBuffer.charAt(i) == '\\'; --i) {
            ++n;
        }
        return n;
    }

    private Directive parseDirective(Token token, String string) throws ParsingException {
        Expression expression;
        String string2;
        int n = string.indexOf(this.syntax.getExpressionBegin());
        if (n > -1) {
            Assert.assertTrue(string.charAt(string.length() - 1) == this.syntax.getExpressionEnd(), "\u5927\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u673a\u6709\u9519\uff01");
            string2 = string.substring(1, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            expression = this.expressionParser.parseExpression(string3.trim());
        } else {
            string2 = string.substring(1, string.length());
            expression = this.expressionParser.parseExpression(null);
        }
        return this.resolveDirective(token, string2.trim(), expression);
    }

    private Directive resolveDirective(Token token, String string, Expression expression) throws ParsingException {
        if (this.syntax.getEndDirectiveName().equals(string)) {
            return EndDirective.END_DIRECTIVE;
        }
        DirectiveHandler directiveHandler = this.directiveHandlerProvider.getDirectiveHandler(string);
        if (directiveHandler == null) {
            throw new ParsingException(token.getLocation(), "\u672a\u627e\u5230" + string + "\u6307\u4ee4\u7684\u5904\u7406\u7c7b!");
        }
        if (directiveHandler instanceof MiddleBlockDirectiveHandler) {
            return new MiddleDirective(string, token.getLocation(), expression, (MiddleBlockDirectiveHandler)directiveHandler, token.getMessage(), this.syntax.getLeader() + this.syntax.getEndDirectiveName());
        }
        if (directiveHandler instanceof BlockDirectiveHandler) {
            return new StartDirective(string, token.getLocation(), expression, (BlockDirectiveHandler)directiveHandler, token.getMessage(), this.syntax.getLeader() + this.syntax.getEndDirectiveName());
        }
        if (directiveHandler instanceof LineDirectiveHandler) {
            return new LineDirective(string, token.getLocation(), expression, (LineDirectiveHandler)directiveHandler, token.getMessage());
        }
        throw new ParsingException(token.getLocation(), directiveHandler.getClass().getName() + "\u4e0d\u662f\u6b63\u786e\u7684\u5904\u7406\u7c7b!");
    }
}

