/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import org.commontemplate.config.UnaryOperatorHandler;
import org.commontemplate.core.EvaluationException;
import org.commontemplate.core.Expression;
import org.commontemplate.core.VariableResolver;
import org.commontemplate.engine.expression.LazyOperandImpl;
import org.commontemplate.engine.expression.UnaryOperatorSupport;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Location;

final class UnaryOperatorImpl
extends UnaryOperatorSupport {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Location location;
    private final int priority;
    private final UnaryOperatorHandler handler;
    private final boolean operandLazy;
    private final boolean operandLiteral;
    private final boolean functionLiteral;

    UnaryOperatorImpl(String string, Location location, int n, UnaryOperatorHandler unaryOperatorHandler) {
        Assert.assertNotNull(unaryOperatorHandler);
        this.name = string;
        this.location = location;
        this.priority = n;
        this.handler = unaryOperatorHandler;
        this.operandLazy = unaryOperatorHandler.isOperandLazy();
        this.operandLiteral = unaryOperatorHandler.isOperandNamed();
        this.functionLiteral = unaryOperatorHandler.isOperandFunctioned();
    }

    public Object evaluate(VariableResolver variableResolver) throws EvaluationException {
        try {
            Object object = this.operandLazy ? new LazyOperandImpl(this.getOperand(), variableResolver) : this.getOperand().evaluate(variableResolver);
            return this.handler.doEvaluate(object);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (Exception exception) {
            throw new EvaluationException((Expression)this, (Throwable)exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getPriority() {
        return this.priority;
    }

    boolean isOperandNamed() {
        return this.operandLiteral;
    }

    public boolean isOperandFunctioned() {
        return this.functionLiteral;
    }
}

