/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.commontemplate.core.EvaluationException;
import org.commontemplate.core.VariableResolver;
import org.commontemplate.engine.expression.UnaryOperatorSupport;
import org.commontemplate.util.Function;
import org.commontemplate.util.Location;

final class FunctionUnaryOperator
extends UnaryOperatorSupport {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Location location;

    FunctionUnaryOperator(String string, Location location) {
        this.name = string;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Object evaluate(VariableResolver variableResolver) throws EvaluationException {
        Object object = this.getOperand().evaluate(variableResolver);
        List<Object> list = null;
        if (object == null) {
            list = new ArrayList(0);
        } else if (object instanceof List) {
            list = (List)object;
        } else {
            list = new ArrayList(1);
            list.add(object);
        }
        return new Function(this.name, list);
    }

    public String getCanonicalForm() {
        return this.name;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Location getLocation() {
        return this.location;
    }
}

