/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.commontemplate.core.BinaryOperator;
import org.commontemplate.core.Expression;
import org.commontemplate.core.Operator;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.UnaryOperator;
import org.commontemplate.engine.expression.BinaryOperatorImpl;
import org.commontemplate.engine.expression.ExpressionFactory;
import org.commontemplate.engine.expression.FunctionUnaryOperator;
import org.commontemplate.engine.expression.Parenthesis;
import org.commontemplate.engine.expression.UnaryOperatorSupport;
import org.commontemplate.util.Position;
import org.commontemplate.util.TypeUtils;
import org.commontemplate.util.scanner.Token;

final class ExpressionTranslator {
    private final ExpressionFactory expressionFactory;
    private boolean functionAvailable;

    ExpressionTranslator(ExpressionFactory expressionFactory, boolean bl) {
        this.expressionFactory = expressionFactory;
        this.functionAvailable = bl;
    }

    public List translate(List list) throws ParsingException {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Token token = (Token)list.get(i);
            if (i > 1 && ("(".equals(((Token)list.get(i - 1)).getMessage().trim()) || "[".equals(((Token)list.get(i - 1)).getMessage().trim())) && (")".equals(token.getMessage().trim()) || "]".equals(token.getMessage().trim()))) {
                this.appendExpression(arrayList, new Token("null", 0L, Position.ZERO), false);
            }
            boolean bl2 = bl = TypeUtils.isNamed(token.getMessage().trim()) && i + 1 < n && "(".equals(((Token)list.get(i + 1)).getMessage().trim());
            if (bl && arrayList.size() > 0) {
                Operator operator;
                Expression expression = (Expression)arrayList.get(arrayList.size() - 1);
                if (expression instanceof BinaryOperatorImpl) {
                    operator = (BinaryOperatorImpl)expression;
                    if (((BinaryOperatorImpl)operator).isRightOperandFunctioned()) {
                        this.appendFunction(arrayList, token);
                        continue;
                    }
                } else if (expression instanceof UnaryOperatorSupport && ((UnaryOperatorSupport)(operator = (UnaryOperatorSupport)expression)).isOperandFunctioned()) {
                    this.appendFunction(arrayList, token);
                    continue;
                }
            }
            this.appendExpression(arrayList, token, bl);
            if (!"[".equals(token.getMessage().trim())) continue;
            this.appendExpression(arrayList, new Token("(", token.getOffset()), false);
        }
        return arrayList;
    }

    private void appendFunction(List list, Token token) throws ParsingException {
        if (!this.functionAvailable) {
            throw new ParsingException(token.getLocation(), "\u7981\u6b62\u8c03\u7528\u51fd\u6570! \u51fd\u6570\u540d:" + token.getMessage() + " (\u914d\u7f6e\u9879functionAvailable=false)");
        }
        list.add(new FunctionUnaryOperator(token.getMessage().trim(), token.getLocation()));
    }

    private void appendExpression(List list, Token token, boolean bl) throws ParsingException {
        Expression expression = null;
        if (list.size() > 0) {
            expression = (Expression)list.get(list.size() - 1);
        }
        if (expression == null || expression == Parenthesis.LEFT_PARENTHESIS || expression instanceof BinaryOperator || expression instanceof UnaryOperator) {
            if (TypeUtils.isMultiOperator(token.getMessage())) {
                this.appendUnaryOperator(list, token, 0);
            } else {
                list.add(this.expressionFactory.getUnaryExpression(token, bl));
            }
        } else if (TypeUtils.isMultiOperator(token.getMessage())) {
            int n = this.maxBinaryOperator(token, token.getMessage());
            list.add(this.expressionFactory.getBinaryExpression(token.subToken(0, n)));
            this.appendUnaryOperator(list, token, n);
        } else {
            list.add(this.expressionFactory.getBinaryExpression(token));
        }
    }

    private void appendUnaryOperator(List list, Token token, int n) throws ParsingException {
        String string = token.getMessage().substring(n);
        if (string.trim().length() > 0) {
            int n2 = n + this.maxUnaryOperator(token, string);
            list.add(this.expressionFactory.getUnaryExpression(token.subToken(n, n2)));
            this.appendUnaryOperator(list, token, n2);
        }
    }

    private int maxUnaryOperator(Token token, String string) throws ParsingException {
        for (int i = string.length(); i > 0; --i) {
            if (!this.expressionFactory.hasUnaryExpression(string.substring(0, i))) continue;
            return i;
        }
        throw new ParsingException(token.getLocation(), string + " \u4e3a\u975e\u6cd5\u7684\u4e00\u5143\u8fd0\u7b97\u7b26\uff01");
    }

    private int maxBinaryOperator(Token token, String string) throws ParsingException {
        for (int i = string.length(); i > 0; --i) {
            if (!this.expressionFactory.hasBinaryExpression(string.substring(0, i))) continue;
            return i;
        }
        throw new ParsingException(token.getLocation(), string + " \u4e3a\u975e\u6cd5\u7684\u4e8c\u5143\u8fd0\u7b97\u7b26\uff01");
    }
}

