/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import java.util.List;
import org.commontemplate.core.BinaryOperator;
import org.commontemplate.core.Constant;
import org.commontemplate.core.Expression;
import org.commontemplate.core.Operator;
import org.commontemplate.core.UnaryOperator;
import org.commontemplate.core.Variable;
import org.commontemplate.engine.expression.BinaryOperatorImpl;
import org.commontemplate.engine.expression.ConstantExpression;
import org.commontemplate.engine.expression.Parenthesis;
import org.commontemplate.engine.expression.UnaryOperatorSupport;
import org.commontemplate.util.LinkedStack;
import org.commontemplate.util.Stack;

final class ExpressionReducer {
    ExpressionReducer() {
    }

    public Expression reduce(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ExpressionStack expressionStack = new ExpressionStack();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)list.get(i);
            if (expression == Parenthesis.RIGHT_PARENTHESIS) {
                while (expressionStack.popOperator() != Parenthesis.LEFT_PARENTHESIS) {
                }
            } else if (expression instanceof BinaryOperator) {
                while (this.isHighPriority(expressionStack.peekOperator(), (BinaryOperator)expression)) {
                    expressionStack.popOperator();
                }
            }
            if (expression == Parenthesis.RIGHT_PARENTHESIS) continue;
            if (expression instanceof Operator) {
                expressionStack.pushOperator((Operator)expression);
                continue;
            }
            expressionStack.pushParameter(expression);
        }
        return expressionStack.popResult();
    }

    private boolean isHighPriority(Operator operator, BinaryOperator binaryOperator) {
        if (operator == null || operator == Parenthesis.LEFT_PARENTHESIS) {
            return false;
        }
        if (operator.getPriority() > binaryOperator.getPriority()) {
            return true;
        }
        return operator.getPriority() == binaryOperator.getPriority() && !((BinaryOperatorImpl)binaryOperator).isRightToLeft();
    }

    private static final class ExpressionStack {
        private Stack operatorStack = new LinkedStack();
        private Stack parameterStack = new LinkedStack();

        private ExpressionStack() {
        }

        public void pushOperator(Operator operator) {
            this.operatorStack.push(operator);
        }

        public void pushParameter(Expression expression) {
            this.parameterStack.push(expression);
        }

        public Operator peekOperator() {
            if (this.operatorStack.isEmpty()) {
                return null;
            }
            return (Operator)this.operatorStack.peek();
        }

        public Operator popOperator() {
            if (this.operatorStack.isEmpty()) {
                throw new RuntimeException("\u62ec\u53f7\u4e0d\u914d\u5bf9! \u7ed3\u675f\u62ec\u53f7\")\"\u7684\u4e2a\u6570\u5927\u4e8e\u5f00\u59cb\u62ec\u53f7\"(\"\u7684\u4e2a\u6570!");
            }
            Operator operator = (Operator)this.operatorStack.pop();
            if (operator instanceof BinaryOperator) {
                BinaryOperator binaryOperator = (BinaryOperator)operator;
                Expression expression = (Expression)this.parameterStack.pop();
                Expression expression2 = (Expression)this.parameterStack.pop();
                this.parameterStack.push(this.populateBinaryOperator((BinaryOperatorImpl)binaryOperator, expression2, expression));
            } else if (operator instanceof UnaryOperator) {
                UnaryOperator unaryOperator = (UnaryOperator)operator;
                Expression expression = (Expression)this.parameterStack.pop();
                this.parameterStack.push(this.populateUnaryOperator((UnaryOperatorSupport)unaryOperator, expression));
            }
            return operator;
        }

        private Expression populateBinaryOperator(BinaryOperatorImpl binaryOperatorImpl, Expression expression, Expression expression2) {
            if (expression instanceof Variable && binaryOperatorImpl.isLeftOperandNamed()) {
                expression = new ConstantExpression(((Variable)expression).getName(), expression.getLocation());
            }
            if (expression2 instanceof Variable && binaryOperatorImpl.isRightOperandNamed()) {
                expression2 = new ConstantExpression(((Variable)expression2).getName(), expression2.getLocation());
            }
            binaryOperatorImpl.relateOperands(expression, expression2);
            try {
                if (expression instanceof Constant && expression2 instanceof Constant) {
                    return new ConstantExpression(binaryOperatorImpl.evaluate(null), binaryOperatorImpl.getLocation());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return binaryOperatorImpl;
        }

        private Expression populateUnaryOperator(UnaryOperatorSupport unaryOperatorSupport, Expression expression) {
            if (expression instanceof Variable && unaryOperatorSupport.isOperandNamed()) {
                expression = new ConstantExpression(((Variable)expression).getName(), expression.getLocation());
            }
            unaryOperatorSupport.relateOperands(expression);
            try {
                if (expression instanceof Constant) {
                    return new ConstantExpression(unaryOperatorSupport.evaluate(null), unaryOperatorSupport.getLocation());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return unaryOperatorSupport;
        }

        public Expression popResult() {
            while (!this.operatorStack.isEmpty()) {
                this.popOperator();
            }
            return (Expression)this.parameterStack.pop();
        }
    }
}

