/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import org.commontemplate.config.Keywords;
import org.commontemplate.config.OperatorHandlerProvider;
import org.commontemplate.core.Expression;
import org.commontemplate.core.ParsingException;
import org.commontemplate.engine.expression.BinaryOperatorImpl;
import org.commontemplate.engine.expression.ConstantExpression;
import org.commontemplate.engine.expression.Parenthesis;
import org.commontemplate.engine.expression.UnaryOperatorImpl;
import org.commontemplate.engine.expression.VariableExpression;
import org.commontemplate.util.NumberUtils;
import org.commontemplate.util.StringConvertUtils;
import org.commontemplate.util.TypeUtils;
import org.commontemplate.util.scanner.Token;

final class ExpressionFactory {
    private final OperatorHandlerProvider operatorHandlerProvider;
    private final Keywords expressionKeywords;
    private final boolean functionAvailable;

    ExpressionFactory(OperatorHandlerProvider operatorHandlerProvider, Keywords keywords, boolean bl) {
        this.operatorHandlerProvider = operatorHandlerProvider;
        this.expressionKeywords = keywords;
        this.functionAvailable = bl;
    }

    boolean hasUnaryExpression(String string) {
        return this.operatorHandlerProvider.hasUnaryOperatorHandler(string.trim());
    }

    boolean hasBinaryExpression(String string) {
        return this.operatorHandlerProvider.hasBinaryOperatorHandler(string.trim());
    }

    public Expression getUnaryExpression(Token token) throws ParsingException {
        return this.getUnaryExpression(token, false);
    }

    public Expression getUnaryExpression(Token token, boolean bl) throws ParsingException {
        String string = token.getMessage().trim();
        if (TypeUtils.isString(string)) {
            return new ConstantExpression(StringConvertUtils.convertLiteral(string.substring(1, string.length() - 1)), token.getLocation());
        }
        if (TypeUtils.isNumber(string)) {
            return new ConstantExpression(NumberUtils.parseNumber(string), token.getLocation());
        }
        if (this.expressionKeywords.getNullKeyword().equals(string)) {
            return new ConstantExpression(null, token.getLocation());
        }
        if (this.expressionKeywords.getTrueKeyword().equals(string)) {
            return new ConstantExpression(Boolean.TRUE, token.getLocation());
        }
        if (this.expressionKeywords.getFalseKeyword().equals(string)) {
            return new ConstantExpression(Boolean.FALSE, token.getLocation());
        }
        if ("(".equals(string)) {
            return Parenthesis.LEFT_PARENTHESIS;
        }
        if (TypeUtils.isNamed(string)) {
            if (!bl) {
                return new VariableExpression(string, token.getLocation());
            }
            if (!this.functionAvailable) {
                throw new ParsingException(token.getLocation(), "\u7981\u6b62\u8c03\u7528\u51fd\u6570! \u51fd\u6570\u540d:" + string + " (\u914d\u7f6e\u9879functionAvailable=false)");
            }
        }
        if (this.operatorHandlerProvider.hasUnaryOperatorHandler(string)) {
            return new UnaryOperatorImpl(string, token.getLocation(), this.operatorHandlerProvider.getUnaryOperatorPriority(string), this.operatorHandlerProvider.getUnaryOperatorHandler(string));
        }
        throw new ParsingException(token.getLocation(), string + " \u4e3a\u975e\u6cd5\u7684\u4e00\u5143\u8fd0\u7b97\u7b26\u6216\u540d\u79f0\uff01");
    }

    Expression getBinaryExpression(Token token) throws ParsingException {
        String string = token.getMessage().trim();
        if (")".equals(string) || "]".equals(string)) {
            return Parenthesis.RIGHT_PARENTHESIS;
        }
        if (this.operatorHandlerProvider.hasBinaryOperatorHandler(string)) {
            return new BinaryOperatorImpl(string, token.getLocation(), this.operatorHandlerProvider.getBinaryOperatorPriority(string), this.operatorHandlerProvider.getBinaryOperatorHandler(string));
        }
        throw new ParsingException(token.getLocation(), string + " \u4e3a\u975e\u6cd5\u7684\u4e8c\u5143\u8fd0\u7b97\u7b26\uff01");
    }
}

