/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import java.io.IOException;
import java.util.List;
import org.commontemplate.config.ExpressionConfiguration;
import org.commontemplate.core.Expression;
import org.commontemplate.core.ExpressionParser;
import org.commontemplate.core.ParsingException;
import org.commontemplate.engine.expression.ExpressionFactory;
import org.commontemplate.engine.expression.ExpressionReducer;
import org.commontemplate.engine.expression.ExpressionTokenizer;
import org.commontemplate.engine.expression.ExpressionTranslator;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Location;
import org.commontemplate.util.scanner.ScanningException;

public final class ExpressionEngine
implements ExpressionParser {
    private final ExpressionTokenizer expressionTokenizer;
    private final ExpressionTranslator expressionTranslator;
    private final ExpressionReducer expressionReducer;

    public ExpressionEngine(ExpressionConfiguration expressionConfiguration) {
        Assert.assertNotNull(expressionConfiguration, "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        expressionConfiguration.validate();
        this.expressionTokenizer = new ExpressionTokenizer();
        this.expressionTranslator = new ExpressionTranslator(new ExpressionFactory(expressionConfiguration.getOperatorHandlerProvider(), expressionConfiguration.getKeywords(), expressionConfiguration.isFunctionAvailable()), expressionConfiguration.isFunctionAvailable());
        this.expressionReducer = new ExpressionReducer();
    }

    public final Expression parseExpression(String string) throws ParsingException {
        try {
            List list = this.expressionTokenizer.split(string);
            List list2 = this.expressionTranslator.translate(list);
            Expression expression = this.expressionReducer.reduce(list2);
            return expression;
        }
        catch (ParsingException parsingException) {
            throw parsingException;
        }
        catch (ScanningException scanningException) {
            throw new ParsingException(new Location(scanningException.getOffset().getPosition(), scanningException.getOffset().getPosition()), (Throwable)scanningException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

