/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import org.commontemplate.core.Constant;
import org.commontemplate.core.Visitor;
import org.commontemplate.util.Location;

public class ConstantExpression
extends Constant {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private final Location location;

    public ConstantExpression(Object object, Location location) {
        super(object);
        this.value = object;
        this.location = location;
    }

    public String getName() {
        return String.valueOf(this.value);
    }

    public String getCanonicalForm() {
        if (this.value instanceof String) {
            return "\"" + this.value + "\"";
        }
        return String.valueOf(this.value);
    }

    public Location getLocation() {
        return this.location;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

