/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commontemplate.config.BinaryOperatorHandler;
import org.commontemplate.core.BinaryOperator;
import org.commontemplate.core.EvaluationException;
import org.commontemplate.core.Expression;
import org.commontemplate.core.VariableResolver;
import org.commontemplate.core.Visitor;
import org.commontemplate.engine.expression.LazyOperandImpl;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Location;

final class BinaryOperatorImpl
extends BinaryOperator {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Location location;
    private final int priority;
    private final BinaryOperatorHandler handler;
    private final boolean rightToLeft;
    private final boolean leftOperandLazy;
    private final boolean rightOperandLazy;
    private final boolean leftOperandNamed;
    private final boolean rightOperandNamed;
    private final boolean rightOperandFunctioned;
    private Expression leftOperand;
    private Expression rightOperand;
    private List operands;

    BinaryOperatorImpl(String string, Location location, int n, BinaryOperatorHandler binaryOperatorHandler) {
        Assert.assertNotNull(binaryOperatorHandler);
        this.name = string;
        this.location = location;
        this.priority = n;
        this.handler = binaryOperatorHandler;
        this.rightToLeft = binaryOperatorHandler.isRightToLeft();
        this.leftOperandLazy = binaryOperatorHandler.isLeftOperandLazy();
        this.rightOperandLazy = binaryOperatorHandler.isRightOperandLazy();
        this.leftOperandNamed = binaryOperatorHandler.isLeftOperandNamed();
        this.rightOperandNamed = binaryOperatorHandler.isRightOperandNamed();
        this.rightOperandFunctioned = binaryOperatorHandler.isRightOperandFunctioned();
    }

    public Object evaluate(VariableResolver variableResolver) throws EvaluationException {
        try {
            Object object = this.leftOperandLazy ? new LazyOperandImpl(this.getLeftOperand(), variableResolver) : this.getLeftOperand().evaluate(variableResolver);
            Object object2 = this.rightOperandLazy ? new LazyOperandImpl(this.getRightOperand(), variableResolver) : this.getRightOperand().evaluate(variableResolver);
            return this.handler.doEvaluate(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (Exception exception) {
            throw new EvaluationException((Expression)this, (Throwable)exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRightToLeft() {
        return this.rightToLeft;
    }

    boolean isLeftOperandNamed() {
        return this.leftOperandNamed;
    }

    boolean isRightOperandNamed() {
        return this.rightOperandNamed;
    }

    public boolean isRightOperandFunctioned() {
        return this.rightOperandFunctioned;
    }

    public String getCanonicalForm() {
        Expression expression = this.getLeftOperand();
        String string = expression.getCanonicalForm();
        if (expression instanceof BinaryOperator && ((BinaryOperator)expression).getPriority() < this.getPriority()) {
            string = "(" + string + ")";
        }
        Expression expression2 = this.getRightOperand();
        String string2 = expression2.getCanonicalForm();
        if (expression2 instanceof BinaryOperator && ((BinaryOperator)expression2).getPriority() < this.getPriority()) {
            string2 = "(" + string2 + ")";
        }
        return string + " " + this.getName() + " " + string2;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getLeftOperand().accept(visitor);
        this.getRightOperand().accept(visitor);
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    public List getOperands() {
        return this.operands;
    }

    void relateOperands(Expression expression, Expression expression2) {
        this.leftOperand = expression;
        this.rightOperand = expression2;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        arrayList.add(expression);
        arrayList.add(expression2);
        this.operands = Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        return this.getLeftOperand().getName() + this.getName() + this.getRightOperand().getName();
    }
}

