/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.util.Iterator;
import java.util.Map;
import org.commontemplate.config.Keywords;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.core.VariableStorage;
import org.commontemplate.util.Assert;
import org.commontemplate.util.TypeUtils;

abstract class VariableStorageSupport
implements VariableStorage {
    protected final Keywords expressionKeywords;

    public VariableStorageSupport(Keywords keywords) {
        Assert.assertNotNull(keywords);
        this.expressionKeywords = keywords;
    }

    protected void assertVariables(Map map) throws VariableException {
        if (map != null && map.size() > 0) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.assertVariableName(string);
                if (!this.isDefinedVariable(string)) continue;
                throw new DefinedException(string + " \u5df2\u7ecf\u5b9a\u4e49!", string);
            }
        }
    }

    protected void assertVariableName(String string) throws VariableException {
        if (string == null) {
            throw new VariableException("\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a!", null);
        }
        if (!TypeUtils.isNamed(string)) {
            throw new VariableException(string + " \u4e0d\u7b26\u5408\u547d\u540d\u89c4\u8303!", string);
        }
        if (this.expressionKeywords.isKeyword(string)) {
            throw new VariableException("\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u5173\u952e\u5b57: " + string, string);
        }
    }
}

