/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.util.Iterator;
import java.util.List;
import org.commontemplate.config.TemplateNameFilter;
import org.commontemplate.core.EventPublisher;
import org.commontemplate.core.Template;
import org.commontemplate.core.TemplateStack;
import org.commontemplate.core.event.TemplatePopedEvent;
import org.commontemplate.core.event.TemplatePushedEvent;
import org.commontemplate.util.Assert;
import org.commontemplate.util.LinkedStack;
import org.commontemplate.util.Stack;

final class TemplateStackImpl
implements TemplateStack {
    private final EventPublisher eventPublisher;
    private final TemplateNameFilter templateNameFilter;
    private final Stack templateNameStack = new LinkedStack();

    TemplateStackImpl(EventPublisher eventPublisher, TemplateNameFilter templateNameFilter) {
        this.eventPublisher = eventPublisher;
        this.templateNameFilter = templateNameFilter;
    }

    public Template getCurrentTemplate() {
        if (this.templateNameStack.isEmpty()) {
            return null;
        }
        return (Template)this.templateNameStack.peek();
    }

    public void pushTemplate(Template template) {
        Template template2 = this.getCurrentTemplate();
        this.templateNameStack.push(template);
        this.eventPublisher.publishEvent(new TemplatePushedEvent(this, template, template2));
    }

    public void popTemplate() {
        Template template = (Template)this.templateNameStack.pop();
        this.eventPublisher.publishEvent(new TemplatePopedEvent(this, this.getCurrentTemplate(), template));
    }

    public List getTemplateStackValues() {
        return this.templateNameStack.values();
    }

    public void clearTemplates() {
        this.templateNameStack.clear();
    }

    public boolean containsTemplate(String string) {
        List list = this.templateNameStack.values();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            if (template == null || !string.equals(template.getName())) continue;
            return true;
        }
        return false;
    }

    public String relateTemplateName(String string) {
        if (this.templateNameFilter != null) {
            Template template = this.getCurrentTemplate();
            return this.templateNameFilter.filter(string, template == null ? null : template.getName());
        }
        return string;
    }

    public Template findTemplate(String string) {
        Assert.assertNotEmpty(string, "\u4e0d\u80fd\u67e5\u627e\u7a7a\u7684\u6a21\u677f\u540d\u79f0!");
        List list = this.templateNameStack.values();
        Template template = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Template template2 = (Template)iterator.next();
            if (template2 == null || !string.equals(template2.getName())) continue;
            template = template2;
        }
        return template;
    }
}

