/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.IOException;
import org.commontemplate.config.Cache;
import org.commontemplate.config.ReloadController;
import org.commontemplate.config.ResourceComparator;
import org.commontemplate.core.Expression;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.Resource;
import org.commontemplate.core.ResourceLoader;
import org.commontemplate.core.Template;
import org.commontemplate.core.TemplateFactory;
import org.commontemplate.core.TemplateParser;
import org.commontemplate.util.Assert;
import org.commontemplate.util.ResourceEntry;

final class TemplateFactoryImpl
implements TemplateFactory {
    private final ReloadController reloadController;
    private final ResourceComparator resourceComparator;
    private final Cache cache;
    private final ResourceLoader resourceLoader;
    private final TemplateParser templateParser;

    TemplateFactoryImpl(TemplateParser templateParser, ResourceLoader resourceLoader, Cache cache, ReloadController reloadController, ResourceComparator resourceComparator) {
        Assert.assertNotNull(resourceLoader, "resourceLoader\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.assertNotNull(templateParser, "templateParser\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.resourceLoader = resourceLoader;
        this.templateParser = templateParser;
        this.cache = cache;
        this.reloadController = reloadController;
        this.resourceComparator = resourceComparator;
    }

    public Template getTemplate(String string) throws IOException, ParsingException {
        return this.cache(this.filterName(string), null);
    }

    public Template getTemplate(String string, String string2) throws IOException, ParsingException {
        return this.cache(this.filterName(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template cache(String string, String string2) throws IOException, ParsingException {
        ResourceEntry resourceEntry;
        if (this.cache == null) {
            return this.templateParser.parseTemplate(this.load(string, string2));
        }
        Object object = this.cache;
        synchronized (object) {
            resourceEntry = (ResourceEntry)this.cache.get(string);
            if (resourceEntry == null) {
                resourceEntry = new ResourceEntry();
                this.cache.put(string, resourceEntry);
            }
        }
        object = resourceEntry;
        synchronized (object) {
            Template template = (Template)resourceEntry.get();
            if (template == null) {
                Resource resource = this.load(string, string2);
                template = this.templateParser.parseTemplate(resource);
                resourceEntry.set(template);
            } else if (this.reloadController != null && this.reloadController.shouldReload(string)) {
                Resource resource = this.load(string, string2);
                if (this.resourceComparator != null && this.resourceComparator.isModified(template, resource)) {
                    template = this.templateParser.parseTemplate(resource);
                    resourceEntry.set(template);
                }
            }
            return template;
        }
    }

    private Resource load(String string, String string2) throws IOException {
        if (string2 == null) {
            return this.resourceLoader.loadResource(string);
        }
        return this.resourceLoader.loadResource(string, string2);
    }

    public Resource loadResource(String string) throws IOException {
        return this.resourceLoader.loadResource(this.filterName(string));
    }

    public Resource loadResource(String string, String string2) throws IOException {
        return this.resourceLoader.loadResource(this.filterName(string), string2);
    }

    private String filterName(String string) {
        if (string == null) {
            throw new NullPointerException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3anull\uff01");
        }
        if ((string = string.trim()).length() == 0) {
            throw new NullPointerException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        char c = string.charAt(0);
        if (c != '/' && c != '\\') {
            string = "/" + string;
        }
        return string;
    }

    public Expression parseExpression(String string) throws ParsingException {
        return this.templateParser.parseExpression(string);
    }

    public Template parseTemplate(String string) throws ParsingException {
        return this.templateParser.parseTemplate(string);
    }

    public Template parseTemplate(Resource resource) throws ParsingException, IOException {
        return this.templateParser.parseTemplate(resource);
    }
}

