/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.commontemplate.core.Context;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.OutputController;
import org.commontemplate.core.OutputFilter;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.UnformattedException;

final class OutputControllerImpl
implements OutputController {
    private final LocalContext superLocalContext;
    private final Context context;
    private final Writer out;
    private OutputFilter outputFilter;
    private OutputFormatter generalFormatter;
    private final Map typeFormatters = new HashMap();
    private OutputFormatter nullFormatter;
    private static final OutputFormatter DEFAULT_FORMATTER = new OutputFormatter(){
        private static final long serialVersionUID = 1L;

        public String format(Object object, Locale locale, TimeZone timeZone) throws UnformattedException {
            return object == null ? null : object.toString();
        }
    };

    OutputControllerImpl(LocalContext localContext, Context context, Writer writer) {
        this.superLocalContext = localContext;
        this.context = context;
        this.out = writer;
    }

    public void setOutputFilter(OutputFilter outputFilter) {
        this.outputFilter = outputFilter;
    }

    public OutputFilter getOutputFilter() {
        return this.outputFilter;
    }

    public void removeOutputFilter() {
        this.outputFilter = null;
    }

    public void setGeneralOutputFormatter(OutputFormatter outputFormatter) {
        this.generalFormatter = outputFormatter;
    }

    public OutputFormatter getGeneralOutputFormatter() {
        return this.generalFormatter;
    }

    public void removeGeneralOutputFormatter() {
        this.generalFormatter = null;
    }

    public void setOutputFormatter(Class clazz, OutputFormatter outputFormatter) {
        if (clazz == null) {
            this.nullFormatter = outputFormatter;
        } else {
            this.typeFormatters.put(clazz, outputFormatter);
        }
    }

    public OutputFormatter getOutputFormatter(Class clazz) {
        if (clazz == null) {
            return this.nullFormatter;
        }
        return (OutputFormatter)this.typeFormatters.get(clazz);
    }

    public void removeOutputFormatter(Class clazz) {
        if (clazz == null) {
            this.nullFormatter = null;
        } else {
            this.typeFormatters.remove(clazz);
        }
    }

    public void clearOutputFormatters() {
        this.generalFormatter = null;
        this.nullFormatter = null;
        this.typeFormatters.clear();
    }

    public void output(Object object) throws IOException {
        if (object instanceof String) {
            this.outputText((String)object);
        } else {
            this.outputText(this.format(object));
        }
    }

    private void outputText(String string) throws IOException {
        if (this.outputFilter != null) {
            string = this.outputFilter.filter(string);
        }
        if (this.superLocalContext != null) {
            this.superLocalContext.output(string);
        } else if (string != null) {
            this.out.write(string);
        }
    }

    public String format(Object object) {
        try {
            if (object == null) {
                if (this.nullFormatter != null) {
                    return this.nullFormatter.format(null, this.context.getLocale(), this.context.getTimeZone());
                }
            } else if (this.typeFormatters != null && this.typeFormatters.size() > 0) {
                Iterator iterator = this.typeFormatters.entrySet().iterator();
                while (iterator.hasNext()) {
                    OutputFormatter outputFormatter;
                    Map.Entry entry = iterator.next();
                    Class clazz = (Class)entry.getKey();
                    if (clazz == null || !clazz.isAssignableFrom(object.getClass()) || (outputFormatter = (OutputFormatter)entry.getValue()) == null) continue;
                    return outputFormatter.format(object, this.context.getLocale(), this.context.getTimeZone());
                }
            }
            if (this.generalFormatter != null) {
                return this.generalFormatter.format(object, this.context.getLocale(), this.context.getTimeZone());
            }
        }
        catch (UnformattedException unformattedException) {
            // empty catch block
        }
        if (this.superLocalContext != null) {
            return this.superLocalContext.format(object);
        }
        return DEFAULT_FORMATTER.format(object, this.context.getLocale(), this.context.getTimeZone());
    }
}

