/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.commontemplate.config.Keywords;
import org.commontemplate.core.Context;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.UndefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.core.event.VariableChangedEvent;
import org.commontemplate.engine.VariableStorageSupport;
import org.commontemplate.util.Assert;

final class LocalVariableStorageImpl
extends VariableStorageSupport {
    private final LocalContext superLocalContext;
    private final Context context;
    private final Map variablesContainer;
    private final Map aliasContainer = new HashMap();
    private final Set readonlyContainer = new HashSet();
    private boolean isLock = false;

    LocalVariableStorageImpl(LocalContext localContext, Map map, Context context, Keywords keywords) {
        super(keywords);
        Assert.assertNotNull(context);
        this.superLocalContext = localContext;
        this.context = context;
        this.variablesContainer = map == null ? new HashMap() : map;
    }

    private void variableChanged(String string, Object object, Object object2) {
        if (object2 == null && object != null || object2 != null && !object2.equals(object)) {
            this.context.publishEvent(new VariableChangedEvent(this, string, object, object2));
        }
    }

    public boolean isDefinedVariable(String string) throws VariableException {
        this.assertVariableName(string);
        return this.variablesContainer.containsKey(string);
    }

    public void defineVariable(String string, Object object) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u5b9a\u4e49\uff1a" + string, string);
        }
        this.assertVariableName(string);
        if (this.isDefinedVariable(string)) {
            throw new DefinedException(string + " \u5df2\u7ecf\u5b9a\u4e49!", string);
        }
        this.variablesContainer.put(string, object);
        this.variableChanged(string, null, object);
    }

    public void defineVariable(String string) throws DefinedException, VariableException {
        this.defineVariable(string, null);
    }

    public void defineReadonlyVariable(String string, Object object) throws DefinedException, VariableException {
        this.defineVariable(string, object);
        this.readonlyContainer.add(string);
    }

    public void defineVariableAlias(String string, String string2) throws VariableException {
        this.aliasContainer.put(string, string2);
    }

    public void defineAllVariables(Map map) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u5b9a\u4e49\uff1a" + map.keySet().toString(), map.keySet().toString());
        }
        this.assertVariables(map);
        this.variablesContainer.putAll(map);
    }

    public void removeVariableAlias(String string) throws VariableException {
        this.aliasContainer.remove(string);
    }

    public void assignVariable(String string, Object object) throws UndefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u8d4b\u503c\uff1a" + string, string);
        }
        this.assertVariableName(string);
        if (this.isDefinedVariable(string)) {
            if (this.readonlyContainer.contains(string)) {
                throw new VariableException(string + " \u4e3a\u53ea\u8bfb\u53d8\u91cf!", string);
            }
            Object v = this.variablesContainer.get(string);
            this.variablesContainer.put(string, object);
            this.variableChanged(string, v, object);
        } else if (this.superLocalContext == null) {
            this.context.getGlobalContext().assignVariable(string, object);
        } else {
            this.superLocalContext.assignVariable(string, object);
        }
    }

    public void lockVariables() {
        this.isLock = true;
    }

    public void unlockVariables() {
        this.isLock = false;
    }

    public Object lookupVariable(String string) throws UndefinedException, VariableException {
        if (this.expressionKeywords.getSuperLocalContextKeyword().equals(string)) {
            if (this.superLocalContext == null) {
                return this.context.getGlobalContext();
            }
            return this.superLocalContext;
        }
        if (this.expressionKeywords.getContextKeyword().equals(string)) {
            return this.context;
        }
        this.assertVariableName(string);
        if (this.isDefinedVariable(string)) {
            return this.variablesContainer.get(string);
        }
        if (this.aliasContainer.containsKey(string)) {
            return this.variablesContainer.get(this.aliasContainer.get(string));
        }
        if (this.superLocalContext == null) {
            return this.context.getGlobalContext().lookupVariable(string);
        }
        return this.superLocalContext.lookupVariable(string);
    }

    public void removeVariable(String string) throws UndefinedException, VariableException {
        Map.Entry entry;
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u79fb\u9664\uff1a" + string, string);
        }
        this.assertVariableName(string);
        Object v = this.variablesContainer.get(string);
        this.variablesContainer.remove(string);
        this.readonlyContainer.remove(string);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.aliasContainer.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!string.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            this.aliasContainer.remove(entry);
        }
        hashSet.clear();
        this.variableChanged(string, v, null);
    }

    public void clearVariables() {
        this.variablesContainer.clear();
        this.aliasContainer.clear();
        this.readonlyContainer.clear();
    }

    public Map getDefinedVariables() {
        return Collections.unmodifiableMap(this.variablesContainer);
    }
}

