/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.commontemplate.core.Context;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.ObjectStorage;

final class LocalObjectStorageImpl
implements ObjectStorage {
    private final LocalContext superLocalContext;
    private final Context context;
    private final Map defaultObjectContainer = new HashMap();
    private final Map objectContainers = new HashMap();

    LocalObjectStorageImpl(LocalContext localContext, Context context) {
        this.superLocalContext = localContext;
        this.context = context;
    }

    public Object lookupObject(String string) {
        Object v = this.defaultObjectContainer.get(string);
        if (v != null) {
            return v;
        }
        if (this.superLocalContext != null) {
            return this.superLocalContext.lookupObject(string);
        }
        return this.context.getGlobalContext().lookupObject(string);
    }

    public void putObject(String string, Object object) {
        this.defaultObjectContainer.put(string, object);
    }

    public void removeObject(String string) {
        this.defaultObjectContainer.remove(string);
    }

    private Map getObjectContainer(String string) {
        HashMap hashMap = (HashMap)this.objectContainers.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.objectContainers.put(string, hashMap);
        }
        return hashMap;
    }

    public Object lookupObject(String string, String string2) {
        Object v = this.getObjectContainer(string).get(string2);
        if (v != null) {
            return v;
        }
        if (this.superLocalContext != null) {
            return this.superLocalContext.lookupObject(string, string2);
        }
        return this.context.getGlobalContext().lookupObject(string, string2);
    }

    public void putObject(String string, String string2, Object object) {
        this.getObjectContainer(string).put(string2, object);
    }

    public void removeObject(String string, String string2) {
        this.getObjectContainer(string).remove(string2);
    }

    public void clearObjects() {
        this.defaultObjectContainer.clear();
        Iterator iterator = this.objectContainers.values().iterator();
        while (iterator.hasNext()) {
            ((Map)iterator.next()).clear();
        }
        this.objectContainers.clear();
    }
}

