/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.commontemplate.config.Keywords;
import org.commontemplate.core.Context;
import org.commontemplate.core.EventPublisher;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.LocalContextStack;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.event.LocalContextPopedEvent;
import org.commontemplate.core.event.LocalContextPushedEvent;
import org.commontemplate.engine.LocalContextImpl;
import org.commontemplate.util.Assert;
import org.commontemplate.util.LinkedStack;
import org.commontemplate.util.Stack;

final class LocalContextStackImpl
implements LocalContextStack {
    private final Writer out;
    private final EventPublisher eventPublisher;
    private final Context context;
    private final Stack localContextStack = new LinkedStack();
    private final LocalContext rootLocalContext;
    private final Keywords expressionKeywords;

    LocalContextStackImpl(Writer writer, OutputFormatter outputFormatter, EventPublisher eventPublisher, Context context, Keywords keywords) {
        this.expressionKeywords = keywords;
        this.out = writer;
        this.context = context;
        this.eventPublisher = eventPublisher;
        this.rootLocalContext = new LocalContextImpl(null, "root", null, context, writer, keywords);
        this.rootLocalContext.setGeneralOutputFormatter(outputFormatter);
        this.localContextStack.push(this.rootLocalContext);
    }

    public LocalContext getRootLocalContext() {
        return this.rootLocalContext;
    }

    public void pushLocalContext() {
        this.pushLocalContext(null, null);
    }

    public void pushLocalContext(String string) {
        this.pushLocalContext(string, null);
    }

    public void pushLocalContext(Map map) {
        this.pushLocalContext(null, map);
    }

    public void pushLocalContext(String string, Map map) {
        LocalContext localContext = null;
        if (!this.localContextStack.isEmpty()) {
            localContext = this.getCurrentLocalContext();
        }
        LocalContextImpl localContextImpl = new LocalContextImpl(localContext, string, map, this.context, this.out, this.expressionKeywords);
        this.localContextStack.push(localContextImpl);
        this.eventPublisher.publishEvent(new LocalContextPushedEvent(this, localContextImpl));
    }

    public void popLocalContext() {
        LocalContext localContext = (LocalContext)this.localContextStack.pop();
        this.eventPublisher.publishEvent(new LocalContextPopedEvent(this, localContext));
        localContext.clear();
    }

    public LocalContext getCurrentLocalContext() {
        return (LocalContext)this.localContextStack.peek();
    }

    public LocalContext findLocalContext(String string) {
        Assert.assertNotEmpty(string, "\u4e0d\u80fd\u67e5\u627e\u7a7a\u7684\u53d8\u91cf\u533a\u57df\u540d\u79f0!");
        List list = this.localContextStack.values();
        LocalContext localContext = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LocalContext localContext2 = (LocalContext)iterator.next();
            if (localContext2 == null || !string.equals(localContext2.getLocalContextName())) continue;
            localContext = localContext2;
        }
        return localContext;
    }

    public List getLocalContextStackValues() {
        return this.localContextStack.values();
    }

    public void clearLocalContexts() {
        while (!this.localContextStack.isEmpty()) {
            this.popLocalContext();
        }
        this.localContextStack.clear();
    }
}

