/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.commontemplate.config.Keywords;
import org.commontemplate.core.Context;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.ObjectStorage;
import org.commontemplate.core.OutputController;
import org.commontemplate.core.OutputFilter;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.StatusStorage;
import org.commontemplate.core.UndefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.core.VariableStorage;
import org.commontemplate.engine.LocalObjectStorageImpl;
import org.commontemplate.engine.LocalStatusStorageImpl;
import org.commontemplate.engine.LocalVariableStorageImpl;
import org.commontemplate.engine.OutputControllerImpl;
import org.commontemplate.util.Assert;

final class LocalContextImpl
extends LocalContext {
    private final LocalContext superLocalContext;
    private final String localContextName;
    private final VariableStorage variableStorage;
    private final StatusStorage statusStorage;
    private final ObjectStorage objectStorage;
    private final OutputController outputController;

    LocalContextImpl(LocalContext localContext, String string, Map map, Context context, Writer writer, Keywords keywords) {
        Assert.assertNotNull(context);
        Assert.assertNotNull(keywords);
        this.superLocalContext = localContext;
        this.localContextName = string;
        this.variableStorage = new LocalVariableStorageImpl(localContext, map, context, keywords);
        this.statusStorage = new LocalStatusStorageImpl(context);
        this.objectStorage = new LocalObjectStorageImpl(localContext, context);
        this.outputController = new OutputControllerImpl(localContext, context, writer);
    }

    public LocalContext getSuperLocalContext() {
        return this.superLocalContext;
    }

    public String getLocalContextName() {
        return this.localContextName;
    }

    public void assignVariable(String string, Object object) throws UndefinedException, VariableException {
        this.variableStorage.assignVariable(string, object);
    }

    public void clearVariables() {
        this.variableStorage.clearVariables();
    }

    public void defineAllVariables(Map map) throws DefinedException, VariableException {
        this.variableStorage.defineAllVariables(map);
    }

    public void defineReadonlyVariable(String string, Object object) throws DefinedException, VariableException {
        this.variableStorage.defineReadonlyVariable(string, object);
    }

    public void defineVariable(String string, Object object) throws DefinedException, VariableException {
        this.variableStorage.defineVariable(string, object);
    }

    public void defineVariable(String string) throws DefinedException, VariableException {
        this.variableStorage.defineVariable(string);
    }

    public void defineVariableAlias(String string, String string2) throws VariableException {
        this.variableStorage.defineVariableAlias(string, string2);
    }

    public void removeVariableAlias(String string) throws VariableException {
        this.variableStorage.removeVariableAlias(string);
    }

    public Map getDefinedVariables() {
        return this.variableStorage.getDefinedVariables();
    }

    public boolean isDefinedVariable(String string) throws VariableException {
        return this.variableStorage.isDefinedVariable(string);
    }

    public void lockVariables() {
        this.variableStorage.lockVariables();
    }

    public Object lookupVariable(String string) throws VariableException {
        return this.variableStorage.lookupVariable(string);
    }

    public void removeVariable(String string) throws UndefinedException, VariableException {
        this.variableStorage.removeVariable(string);
    }

    public void unlockVariables() {
        this.variableStorage.unlockVariables();
    }

    public void clearStatus() {
        this.statusStorage.clearStatus();
    }

    public Object getStatus(String string) {
        return this.statusStorage.getStatus(string);
    }

    public void removeStatus(String string) {
        this.statusStorage.removeStatus(string);
    }

    public void setStatus(String string, Object object) {
        this.statusStorage.setStatus(string, object);
    }

    public void clearObjects() {
        this.objectStorage.clearObjects();
    }

    public Object lookupObject(String string, String string2) {
        return this.objectStorage.lookupObject(string, string2);
    }

    public Object lookupObject(String string) {
        return this.objectStorage.lookupObject(string);
    }

    public void putObject(String string, Object object) {
        this.objectStorage.putObject(string, object);
    }

    public void putObject(String string, String string2, Object object) {
        this.objectStorage.putObject(string, string2, object);
    }

    public void removeObject(String string, String string2) {
        this.objectStorage.removeObject(string, string2);
    }

    public void removeObject(String string) {
        this.objectStorage.removeObject(string);
    }

    public void clearOutputFormatters() {
        this.outputController.clearOutputFormatters();
    }

    public String format(Object object) {
        return this.outputController.format(object);
    }

    public void output(Object object) throws IOException {
        this.outputController.output(object);
    }

    public void removeGeneralOutputFormatter() {
        this.outputController.removeGeneralOutputFormatter();
    }

    public void removeOutputFilter() {
        this.outputController.removeOutputFilter();
    }

    public void removeOutputFormatter(Class clazz) {
        this.outputController.removeOutputFormatter(clazz);
    }

    public void setGeneralOutputFormatter(OutputFormatter outputFormatter) {
        this.outputController.setGeneralOutputFormatter(outputFormatter);
    }

    public void setOutputFilter(OutputFilter outputFilter) {
        this.outputController.setOutputFilter(outputFilter);
    }

    public void setOutputFormatter(Class clazz, OutputFormatter outputFormatter) {
        this.outputController.setOutputFormatter(clazz, outputFormatter);
    }

    public OutputFormatter getGeneralOutputFormatter() {
        return this.outputController.getGeneralOutputFormatter();
    }

    public OutputFilter getOutputFilter() {
        return this.outputController.getOutputFilter();
    }

    public OutputFormatter getOutputFormatter(Class clazz) {
        return this.outputController.getOutputFormatter(clazz);
    }

    public void clear() {
        super.clear();
        this.clearOutputFormatters();
    }
}

