/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.commontemplate.config.Keywords;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.UndefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.engine.VariableStorageSupport;

final class GlobalVariableStorageImpl
extends VariableStorageSupport {
    private final Map variablesContainer = new HashMap();
    private final Map aliasContainer = new HashMap();
    private final Set readonlyContainer = new HashSet();
    private boolean isLock = false;

    GlobalVariableStorageImpl(Keywords keywords) {
        super(keywords);
    }

    public synchronized void lockVariables() {
        this.isLock = true;
    }

    public synchronized void unlockVariables() {
        this.isLock = false;
    }

    public synchronized boolean isDefinedVariable(String string) throws VariableException {
        return this.variablesContainer.containsKey(string);
    }

    public synchronized void defineVariable(String string, Object object) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", string);
        }
        this.variablesContainer.put(string, object);
    }

    public synchronized void defineVariable(String string) throws DefinedException, VariableException {
        this.defineVariable(string, null);
    }

    public synchronized void defineReadonlyVariable(String string, Object object) throws DefinedException, VariableException {
        this.defineVariable(string, object);
        this.readonlyContainer.add(string);
    }

    public synchronized void defineAllVariables(Map map) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", map.keySet().toString());
        }
        this.variablesContainer.putAll(map);
    }

    public void defineVariableAlias(String string, String string2) throws VariableException {
        this.aliasContainer.put(string, string2);
    }

    public synchronized void assignVariable(String string, Object object) throws UndefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", string);
        }
        this.variablesContainer.put(string, object);
    }

    public synchronized Object lookupVariable(String string) throws VariableException {
        return this.variablesContainer.get(string);
    }

    public synchronized Map getDefinedVariables() {
        return Collections.unmodifiableMap(this.variablesContainer);
    }

    public void removeVariableAlias(String string) throws VariableException {
        this.aliasContainer.remove(string);
    }

    public synchronized void removeVariable(String string) throws UndefinedException, VariableException {
        Map.Entry entry;
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u79fb\u9664\uff1a" + string, string);
        }
        this.assertVariableName(string);
        this.variablesContainer.remove(string);
        this.readonlyContainer.remove(string);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.aliasContainer.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!string.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            this.aliasContainer.remove(entry);
        }
        hashSet.clear();
    }

    public synchronized void clearVariables() {
        this.variablesContainer.clear();
        this.aliasContainer.clear();
        this.readonlyContainer.clear();
    }
}

