/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import org.commontemplate.config.Configuration;
import org.commontemplate.core.Context;
import org.commontemplate.core.ContextFactory;
import org.commontemplate.core.Expression;
import org.commontemplate.core.Factory;
import org.commontemplate.core.GlobalContext;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.Resource;
import org.commontemplate.core.Template;
import org.commontemplate.core.TemplateFactory;
import org.commontemplate.engine.ContextFactoryImpl;
import org.commontemplate.engine.TemplateFactoryImpl;
import org.commontemplate.engine.template.TemplateEngine;
import org.commontemplate.util.Assert;

public final class Engine
implements Factory {
    private final TemplateFactory templateFactory;
    private final ContextFactory contextFactory;

    public Engine(Configuration configuration) {
        Assert.assertNotNull(configuration, "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        this.templateFactory = new TemplateFactoryImpl(new TemplateEngine(configuration), configuration.getResourceLoader(), configuration.getTemplateCache(), configuration.getReloadController(), configuration.getResourceComparator());
        this.contextFactory = new ContextFactoryImpl(this.templateFactory, configuration.getTemplateNameFilter(), configuration.getResourceBundleProvider(), configuration.getDefaultOutputFormatter(), configuration.getEventListener(), configuration.getLogger(), configuration.isDebugMode(), configuration.getKeywords());
    }

    public final Template getTemplate(String string) throws IOException, ParsingException {
        return this.templateFactory.getTemplate(string);
    }

    public final Template getTemplate(String string, String string2) throws IOException, ParsingException {
        return this.templateFactory.getTemplate(string, string2);
    }

    public final Resource loadResource(String string, String string2) throws IOException {
        return this.templateFactory.loadResource(string, string2);
    }

    public final Resource loadResource(String string) throws IOException {
        return this.templateFactory.loadResource(string);
    }

    public final Expression parseExpression(String string) throws ParsingException {
        return this.templateFactory.parseExpression(string);
    }

    public final Template parseTemplate(String string) throws ParsingException {
        return this.templateFactory.parseTemplate(string);
    }

    public Template parseTemplate(Resource resource) throws ParsingException, IOException {
        return this.templateFactory.parseTemplate(resource);
    }

    public final Context createContext(Writer writer) {
        return this.contextFactory.createContext(writer);
    }

    public final Context createContext(Writer writer, Locale locale) {
        return this.contextFactory.createContext(writer, locale);
    }

    public final Context createContext(Writer writer, Locale locale, TimeZone timeZone) {
        return this.contextFactory.createContext(writer, locale, timeZone);
    }

    public final GlobalContext getGlobalContext() {
        return this.contextFactory.getGlobalContext();
    }
}

