/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.commontemplate.config.Keywords;
import org.commontemplate.config.TemplateNameFilter;
import org.commontemplate.core.Context;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.Event;
import org.commontemplate.core.EventListener;
import org.commontemplate.core.EventPublisher;
import org.commontemplate.core.Expression;
import org.commontemplate.core.GlobalContext;
import org.commontemplate.core.LocalContext;
import org.commontemplate.core.LocalContextStack;
import org.commontemplate.core.Logger;
import org.commontemplate.core.MessageSource;
import org.commontemplate.core.NoSuchMessageException;
import org.commontemplate.core.OutputFilter;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.Resource;
import org.commontemplate.core.Template;
import org.commontemplate.core.TemplateFactory;
import org.commontemplate.core.TemplateStack;
import org.commontemplate.core.UndefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.engine.EventPublisherImpl;
import org.commontemplate.engine.LocalContextStackImpl;
import org.commontemplate.engine.MessageSourceImpl;
import org.commontemplate.engine.TemplateStackImpl;
import org.commontemplate.util.Assert;

final class ContextImpl
extends Context {
    private final TemplateNameFilter templateNameFilter;
    private final Keywords expressionKeywords;
    private final EventListener eventListener;
    private final OutputFormatter defaultFormater;
    private final ResourceBundle resourceBundle;
    private final GlobalContext globalContext;
    private final Writer out;
    private final Locale locale;
    private final TimeZone timeZone;
    private final boolean debugMode;
    private final EventPublisher eventPublisher;
    private final TemplateStack templateNameStack;
    private final LocalContextStack localContextStack;
    private final MessageSource messageSource;
    private final TemplateFactory templateFactory;
    private final Logger logger;

    ContextImpl(GlobalContext globalContext, Writer writer, ResourceBundle resourceBundle, Locale locale, TimeZone timeZone, TemplateFactory templateFactory, TemplateNameFilter templateNameFilter, OutputFormatter outputFormatter, EventListener eventListener, Logger logger, boolean bl, Keywords keywords) {
        Assert.assertNotNull(globalContext);
        Assert.assertNotNull(writer);
        Assert.assertNotNull(templateFactory);
        Assert.assertNotNull(keywords);
        this.globalContext = globalContext;
        this.out = writer;
        this.resourceBundle = resourceBundle;
        this.locale = locale;
        this.timeZone = timeZone;
        this.templateFactory = templateFactory;
        this.templateNameFilter = templateNameFilter;
        this.defaultFormater = outputFormatter;
        this.eventListener = eventListener;
        this.logger = logger;
        this.debugMode = bl;
        this.expressionKeywords = keywords;
        this.eventPublisher = new EventPublisherImpl(eventListener, this);
        this.templateNameStack = new TemplateStackImpl(this.eventPublisher, templateNameFilter);
        this.localContextStack = new LocalContextStackImpl(writer, outputFormatter, this.eventPublisher, this, keywords);
        this.messageSource = new MessageSourceImpl(resourceBundle, locale);
    }

    public Context createContext() {
        return new ContextImpl(this.globalContext, this.out, this.resourceBundle, this.locale, this.timeZone, this.templateFactory, this.templateNameFilter, this.defaultFormater, this.eventListener, this.logger, this.debugMode, this.expressionKeywords);
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public Writer getOut() {
        return this.out;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void clear() {
        this.clearLocalContexts();
        this.clearTemplates();
    }

    public void publishEvent(Event event) {
        this.eventPublisher.publishEvent(event);
    }

    public void clearTemplates() {
        this.templateNameStack.clearTemplates();
    }

    public Template getCurrentTemplate() {
        return this.templateNameStack.getCurrentTemplate();
    }

    public List getTemplateStackValues() {
        return this.templateNameStack.getTemplateStackValues();
    }

    public Template findTemplate(String string) {
        return this.templateNameStack.findTemplate(string);
    }

    public void popTemplate() {
        this.templateNameStack.popTemplate();
    }

    public void pushTemplate(Template template) {
        this.templateNameStack.pushTemplate(template);
    }

    public boolean containsTemplate(String string) {
        return this.templateNameStack.containsTemplate(string);
    }

    public String relateTemplateName(String string) {
        return this.templateNameStack.relateTemplateName(string);
    }

    public void clearLocalContexts() {
        this.localContextStack.clearLocalContexts();
    }

    public LocalContext findLocalContext(String string) {
        return this.localContextStack.findLocalContext(string);
    }

    public LocalContext getCurrentLocalContext() {
        return this.localContextStack.getCurrentLocalContext();
    }

    public List getLocalContextStackValues() {
        return this.localContextStack.getLocalContextStackValues();
    }

    public LocalContext getRootLocalContext() {
        return this.localContextStack.getRootLocalContext();
    }

    public void popLocalContext() {
        this.localContextStack.popLocalContext();
    }

    public void pushLocalContext() {
        this.localContextStack.pushLocalContext();
    }

    public void pushLocalContext(String string) {
        this.localContextStack.pushLocalContext(string);
    }

    public void pushLocalContext(Map map) {
        this.localContextStack.pushLocalContext(map);
    }

    public void pushLocalContext(String string, Map map) {
        this.localContextStack.pushLocalContext(string, map);
    }

    public String getMessage(String string, Object[] objectArray, String string2) {
        return this.messageSource.getMessage(string, objectArray, string2);
    }

    public String getMessage(String string, Object[] objectArray) throws NoSuchMessageException {
        return this.messageSource.getMessage(string, objectArray);
    }

    public String getMessage(String string, String string2) {
        return this.messageSource.getMessage(string, string2);
    }

    public String getMessage(String string) throws NoSuchMessageException {
        return this.messageSource.getMessage(string);
    }

    private String getCurrentTemplateEncoding() {
        Template template = this.getCurrentTemplate();
        if (template != null) {
            return template.getEncoding();
        }
        return null;
    }

    public Template getTemplate(String string) throws IOException, ParsingException {
        String string2 = this.getCurrentTemplateEncoding();
        if (string2 != null) {
            return this.templateFactory.getTemplate(this.relateTemplateName(string), string2);
        }
        return this.templateFactory.getTemplate(this.relateTemplateName(string));
    }

    public Template getTemplate(String string, String string2) throws IOException, ParsingException {
        return this.templateFactory.getTemplate(this.relateTemplateName(string), string2);
    }

    public Resource loadResource(String string) throws IOException {
        String string2 = this.getCurrentTemplateEncoding();
        if (string2 != null) {
            return this.templateFactory.getTemplate(this.relateTemplateName(string), string2);
        }
        return this.templateFactory.loadResource(this.relateTemplateName(string));
    }

    public Resource loadResource(String string, String string2) throws IOException {
        return this.templateFactory.loadResource(this.relateTemplateName(string), string2);
    }

    public Expression parseExpression(String string) throws ParsingException {
        return this.templateFactory.parseExpression(string);
    }

    public Template parseTemplate(String string) throws ParsingException {
        return this.templateFactory.parseTemplate(string);
    }

    public Template parseTemplate(Resource resource) throws ParsingException, IOException {
        return this.templateFactory.parseTemplate(resource);
    }

    public void debug(String string, Throwable throwable) {
        if (this.logger != null) {
            this.logger.debug(string, throwable);
        }
    }

    public void debug(String string) {
        if (this.logger != null) {
            this.logger.debug(string);
        }
    }

    public void info(String string) {
        if (this.logger != null) {
            this.logger.info(string);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.logger != null) {
            this.logger.warn(string, throwable);
        }
    }

    public void warn(String string) {
        if (this.logger != null) {
            this.logger.warn(string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.logger != null) {
            this.logger.error(string, throwable);
        }
    }

    public void error(String string) {
        if (this.logger != null) {
            this.logger.error(string);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger != null && this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger != null && this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger != null && this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger != null && this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger != null && this.logger.isFatalEnabled();
    }

    public LocalContext getSuperLocalContext() {
        return this.getCurrentLocalContext().getSuperLocalContext();
    }

    public String getLocalContextName() {
        return this.getCurrentLocalContext().getLocalContextName();
    }

    public void setOutputFilter(OutputFilter outputFilter) {
        this.getCurrentLocalContext().setOutputFilter(outputFilter);
    }

    public void removeOutputFilter() {
        this.getCurrentLocalContext().removeOutputFilter();
    }

    public void setGeneralOutputFormatter(OutputFormatter outputFormatter) {
        this.getCurrentLocalContext().setGeneralOutputFormatter(outputFormatter);
    }

    public void removeGeneralOutputFormatter() {
        this.getCurrentLocalContext().removeGeneralOutputFormatter();
    }

    public void setOutputFormatter(Class clazz, OutputFormatter outputFormatter) {
        this.getCurrentLocalContext().setOutputFormatter(clazz, outputFormatter);
    }

    public void removeOutputFormatter(Class clazz) {
        this.getCurrentLocalContext().removeOutputFormatter(clazz);
    }

    public void clearOutputFormatters() {
        this.getCurrentLocalContext().clearOutputFormatters();
    }

    public void output(Object object) throws IOException {
        this.getCurrentLocalContext().output(object);
    }

    public String format(Object object) {
        return this.getCurrentLocalContext().format(object);
    }

    public OutputFormatter getGeneralOutputFormatter() {
        return this.getCurrentLocalContext().getGeneralOutputFormatter();
    }

    public OutputFilter getOutputFilter() {
        return this.getCurrentLocalContext().getOutputFilter();
    }

    public OutputFormatter getOutputFormatter(Class clazz) {
        return this.getCurrentLocalContext().getOutputFormatter(clazz);
    }

    public boolean isDefinedVariable(String string) throws VariableException {
        return this.getCurrentLocalContext().isDefinedVariable(string);
    }

    public void defineVariable(String string) throws DefinedException, VariableException {
        this.getCurrentLocalContext().defineVariable(string);
    }

    public void defineVariable(String string, Object object) throws DefinedException, VariableException {
        this.getCurrentLocalContext().defineVariable(string, object);
    }

    public void defineReadonlyVariable(String string, Object object) throws DefinedException, VariableException {
        this.getCurrentLocalContext().defineReadonlyVariable(string, object);
    }

    public void defineVariableAlias(String string, String string2) throws VariableException {
        this.getCurrentLocalContext().defineVariableAlias(string, string2);
    }

    public void removeVariableAlias(String string) throws VariableException {
        this.getCurrentLocalContext().removeVariableAlias(string);
    }

    public void assignVariable(String string, Object object) throws UndefinedException, VariableException {
        this.getCurrentLocalContext().assignVariable(string, object);
    }

    public Object lookupVariable(String string) throws UndefinedException, VariableException {
        return this.getCurrentLocalContext().lookupVariable(string);
    }

    public void removeVariable(String string) throws UndefinedException, VariableException {
        this.getCurrentLocalContext().removeVariable(string);
    }

    public void clearVariables() {
        this.getCurrentLocalContext().clearVariables();
    }

    public Map getDefinedVariables() {
        return this.getCurrentLocalContext().getDefinedVariables();
    }

    public void defineAllVariables(Map map) throws DefinedException, VariableException {
        this.getCurrentLocalContext().defineAllVariables(map);
    }

    public void lockVariables() {
        this.getCurrentLocalContext().lockVariables();
    }

    public void unlockVariables() {
        this.getCurrentLocalContext().unlockVariables();
    }

    public Object getStatus(String string) {
        return this.getCurrentLocalContext().getStatus(string);
    }

    public void setStatus(String string, Object object) {
        this.getCurrentLocalContext().setStatus(string, object);
    }

    public void removeStatus(String string) {
        this.getCurrentLocalContext().removeStatus(string);
    }

    public void clearStatus() {
        this.getCurrentLocalContext().clearStatus();
    }

    public void clearObjects() {
        this.getCurrentLocalContext().clearObjects();
    }

    public Object lookupObject(String string, String string2) {
        return this.getCurrentLocalContext().lookupObject(string, string2);
    }

    public void putObject(String string, String string2, Object object) {
        this.getCurrentLocalContext().putObject(string, string2, object);
    }

    public void removeObject(String string, String string2) {
        this.getCurrentLocalContext().removeObject(string, string2);
    }

    public Object lookupObject(String string) {
        return this.getCurrentLocalContext().lookupObject(string);
    }

    public void putObject(String string, Object object) {
        this.getCurrentLocalContext().putObject(string, object);
    }

    public void removeObject(String string) {
        this.getCurrentLocalContext().removeObject(string);
    }
}

