/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.engine;

import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import org.commontemplate.config.Keywords;
import org.commontemplate.config.ResourceBundleProvider;
import org.commontemplate.config.TemplateNameFilter;
import org.commontemplate.core.Context;
import org.commontemplate.core.ContextFactory;
import org.commontemplate.core.EventListener;
import org.commontemplate.core.GlobalContext;
import org.commontemplate.core.Logger;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.TemplateFactory;
import org.commontemplate.engine.ContextImpl;
import org.commontemplate.engine.GlobalContextImpl;
import org.commontemplate.util.Assert;
import org.commontemplate.util.LocaleUtils;

final class ContextFactoryImpl
implements ContextFactory {
    private final GlobalContext globalContext;
    private final TemplateFactory templateFactory;
    private final TemplateNameFilter templateNameFilter;
    private final ResourceBundleProvider resourceBundleProvider;
    private final OutputFormatter defaultFormater;
    private final EventListener eventListener;
    private final Logger logger;
    private final boolean debugMode;
    private final Keywords expressionKeywords;

    ContextFactoryImpl(TemplateFactory templateFactory, TemplateNameFilter templateNameFilter, ResourceBundleProvider resourceBundleProvider, OutputFormatter outputFormatter, EventListener eventListener, Logger logger, boolean bl, Keywords keywords) {
        Assert.assertNotNull(templateFactory);
        Assert.assertNotNull(keywords);
        this.globalContext = new GlobalContextImpl(keywords);
        this.templateFactory = templateFactory;
        this.templateNameFilter = templateNameFilter;
        this.resourceBundleProvider = resourceBundleProvider;
        this.defaultFormater = outputFormatter;
        this.eventListener = eventListener;
        this.logger = logger;
        this.debugMode = bl;
        this.expressionKeywords = keywords;
    }

    public Context createContext(Writer writer) {
        return this.createContext(writer, Locale.getDefault(), TimeZone.getDefault());
    }

    public Context createContext(Writer writer, Locale locale) {
        return this.createContext(writer, locale, LocaleUtils.getDefaultTimeZone(locale));
    }

    public Context createContext(Writer writer, Locale locale, TimeZone timeZone) {
        return new ContextImpl(this.globalContext, writer, this.resourceBundleProvider == null ? null : this.resourceBundleProvider.getResourceBundle(locale), locale, timeZone, this.templateFactory, this.templateNameFilter, this.defaultFormater, this.eventListener, this.logger, this.debugMode, this.expressionKeywords);
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }
}

