/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.config;

import org.commontemplate.util.Assert;

public final class Keywords {
    private final String nullKeyword;
    private final String trueKeyword;
    private final String falseKeyword;
    private final String currentLocalContextKeyword;
    private final String superLocalContextKeyword;
    private final String contextKeyword;
    public static final String DEFAULT_NULL_KEYWORD = "null";
    public static final String DEFAULT_TRUE_KEYWORD = "true";
    public static final String DEFAULT_FALSE_KEYWORD = "false";
    public static final String DEFAULT_CURRENT_LOCAL_CONTEXT_KEYWORD = "this";
    public static final String DEFAULT_SUPER_LOCAL_CONTEXT_KEYWORD = "super";
    public static final String DEFAULT_CONTEXT_KEYWORD = "context";
    public static final Keywords DEFAULT = new Keywords("null", "true", "false", "this", "super", "context");

    public Keywords(String string, String string2, String string3, String string4, String string5, String string6) {
        Assert.assertNotEmpty(string, "NullKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.assertNotEmpty(string2, "TrueKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.assertNotEmpty(string3, "FalseKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.assertNotEmpty(string4, "CurrentLocalContextKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.assertNotEmpty(string5, "SuperLocalContextKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.assertNotEmpty(string6, "ContextKeyword\u4e0d\u80fd\u4e3a\u7a7a!");
        this.assertMutex(new String[]{string, string2, string3, string5, string6});
        this.nullKeyword = string;
        this.trueKeyword = string2;
        this.falseKeyword = string3;
        this.currentLocalContextKeyword = string4;
        this.superLocalContextKeyword = string5;
        this.contextKeyword = string6;
    }

    private final void assertMutex(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!stringArray[i].equals(stringArray[j])) continue;
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5173\u952e\u5b57\u91cd\u590d\uff1a" + stringArray[i]);
            }
        }
    }

    public final String getNullKeyword() {
        return this.nullKeyword;
    }

    public final String getTrueKeyword() {
        return this.trueKeyword;
    }

    public final String getFalseKeyword() {
        return this.falseKeyword;
    }

    public final String getCurrentLocalContextKeyword() {
        return this.currentLocalContextKeyword;
    }

    public final String getSuperLocalContextKeyword() {
        return this.superLocalContextKeyword;
    }

    public final String getContextKeyword() {
        return this.contextKeyword;
    }

    public final boolean isKeyword(String string) {
        if (string == null) {
            return false;
        }
        return this.nullKeyword.equals(string) || this.trueKeyword.equals(string) || this.falseKeyword.equals(string) || this.superLocalContextKeyword.equals(string) || this.contextKeyword.equals(string);
    }
}

