/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.kdom;

import java.io.IOException;
import org.kxml.kdom.Element;
import org.kxml.kdom.Node;
import org.kxml.parser.KXML;

public class Document
extends Node {
    protected int rootIndex = -1;

    public String getName() {
        return "#document";
    }

    public void addChild(int index, int type, Object child) {
        if (type == 4) {
            if (this.rootIndex != -1) {
                throw new RuntimeException("Only one document root element allowed");
            }
            this.rootIndex = index;
        } else if (this.rootIndex >= index) {
            ++this.rootIndex;
        }
        super.addChild(index, type, child);
    }

    public void parse(KXML parser) throws IOException {
        super.parse(parser);
        if (parser.read().getType() != 8) {
            throw new RuntimeException("Document end expected!");
        }
    }

    public void removeChild(int index) {
        if (index == this.rootIndex) {
            this.rootIndex = -1;
        } else if (index < this.rootIndex) {
            --this.rootIndex;
        }
        super.removeChild(index);
    }

    public Element getRootElement() {
        if (this.rootIndex == -1) {
            throw new RuntimeException("Document has no root element!");
        }
        return (Element)this.getChild(this.rootIndex);
    }
}

