/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayIconPopupItem;
import com.jeans.trayicon.WindowsTrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TrayIconPopupSimpleItem
implements TrayIconPopupItem {
    protected String m_Item;
    protected int m_MenuId;
    protected boolean m_Enabled;
    protected boolean m_Default;
    protected WindowsTrayIcon m_TrayIcon;
    private Vector m_Listeners;

    public TrayIconPopupSimpleItem(String item) {
        this.m_Item = item;
        this.m_Enabled = true;
    }

    public String getName() {
        return this.m_Item;
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_Listeners == null) {
            this.m_Listeners = new Vector();
        }
        this.m_Listeners.addElement(listener);
    }

    public int getNbLevels() {
        return 0;
    }

    public void setEnabled(boolean enable) {
        this.m_Enabled = enable;
        if (this.m_TrayIcon != null) {
            this.m_TrayIcon.modifyPopup(this.m_MenuId, 1, this.m_Enabled);
        }
    }

    public void setDefault(boolean def) {
        this.m_Default = def;
        if (this.m_TrayIcon != null) {
            this.m_TrayIcon.modifyPopup(this.m_MenuId, 4, this.m_Default);
        }
    }

    public boolean onSelected(int menuId) {
        boolean selected;
        boolean bl = selected = menuId == this.m_MenuId;
        if (selected && this.m_Listeners != null) {
            ActionEvent evt = new ActionEvent(this, 0, "");
            Enumeration enume = this.m_Listeners.elements();
            while (enume.hasMoreElements()) {
                ActionListener listener = (ActionListener)enume.nextElement();
                listener.actionPerformed(evt);
            }
        }
        return selected;
    }

    public void setTrayIcon(WindowsTrayIcon trayicon, int id, int level) {
        int extra;
        int n = extra = this.m_Enabled ? 1 : 0;
        if (this.m_Default) {
            extra |= 4;
        }
        this.m_MenuId = WindowsTrayIcon.subPopup(id, level, this.m_Item, 0, extra);
        this.m_TrayIcon = trayicon;
    }
}

