/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayDummyComponent;
import com.jeans.trayicon.WindowsTrayIcon;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SwingTrayPopup
extends JPopupMenu {
    WindowsTrayIcon m_Icon;
    MouseListener m_Listener;

    public void setTrayIcon(WindowsTrayIcon icon) {
        if (icon != null) {
            this.m_Icon = icon;
            WindowsTrayIcon.initJAWT();
            WindowsTrayIcon.initHook();
            this.m_Listener = new ActivateListener();
            this.m_Icon.addMouseListener(this.m_Listener);
        } else if (this.m_Icon != null) {
            this.m_Icon.removeMouseListener(this.m_Listener);
            this.m_Icon = null;
        }
    }

    public void showMenu(int xp, int yp) {
        SwingUtilities.invokeLater(new InvokeMenu(xp, yp));
    }

    private boolean componentContains(JComponent comp, int xp, int yp) {
        boolean contains;
        if (!comp.isVisible()) {
            return false;
        }
        Point pt = comp.getLocationOnScreen();
        Dimension s = comp.getSize();
        boolean bl = contains = xp > pt.x && xp < pt.x + s.width && yp > pt.y && yp < pt.y + s.height;
        if (contains) {
            return true;
        }
        int i = 0;
        while (i < comp.getComponentCount()) {
            JMenu submenu;
            JComponent child = (JComponent)comp.getComponent(i);
            if (child instanceof JMenu && this.componentContains((submenu = (JMenu)child).getPopupMenu(), xp, yp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean menuContains(int xp, int yp) {
        return this.componentContains(this, xp, yp);
    }

    private class ActivateListener
    extends MouseAdapter {
        private ActivateListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger() && (evt.getModifiers() & 8) != 0 && evt.getClickCount() == 1) {
                SwingTrayPopup.this.showMenu(evt.getX(), evt.getY());
            }
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (!SwingTrayPopup.this.menuContains(evt.getX(), evt.getY())) {
                SwingTrayPopup.this.setVisible(false);
                WindowsTrayIcon.setMouseClickHook(null);
            }
        }
    }

    private class InvokeMenu
    implements Runnable {
        int m_Xp;
        int m_Yp;

        public InvokeMenu(int x, int y) {
            this.m_Xp = x;
            this.m_Yp = y;
        }

        public void run() {
            TrayDummyComponent frame = WindowsTrayIcon.getDummyComponent();
            WindowsTrayIcon.setMouseClickHook(new ClickListener());
            Dimension d = SwingTrayPopup.this.getPreferredSize();
            SwingTrayPopup.this.show(frame, this.m_Xp - d.width, this.m_Yp - d.height);
            WindowsTrayIcon.setAlwaysOnTop(frame, true);
            SwingTrayPopup.this.updateUI();
        }
    }
}

