/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.ChatPane;
import IM.client.PictureButton;
import IM.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ChatTip
extends JFrame {
    Point origin = new Point();
    JLabel countLabel = new JLabel();
    int RemainSecond;
    ChatApplet chatApplet;
    public PictureButton pbclose;
    JPanel outBorder = null;

    public ChatTip(String title, String tip, int remainSecond, String homeURL, ChatApplet ca) {
        this.CustomView();
        this.chatApplet = ca;
        Container cc = this.getContentPane();
        cc.setBackground(Color.white);
        cc.setLayout(new BorderLayout());
        this.outBorder = new JPanel();
        this.outBorder.setBorder(BorderFactory.createLineBorder(new Color(7576311), 1));
        this.outBorder.setLayout(new BorderLayout());
        cc.add((Component)this.outBorder, "Center");
        ChatPane ep = new ChatPane(ca);
        Color c = new Color(4747475);
        this.countLabel.setForeground(Color.WHITE);
        this.countLabel.setBackground(c);
        this.countLabel.setOpaque(true);
        Border border = BorderFactory.createLineBorder(c, 3);
        ep.setBorder(null);
        JScrollPane sp = new JScrollPane(ep);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setBorder(border);
        this.RemainSecond = remainSecond;
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        ImageIcon img = new ImageIcon(Tools.GetImageFromURL(this.chatApplet, "IM/res/skin/tip.gif"));
        JLabel left = new JLabel(img);
        left.setBackground(c);
        jp.add((Component)left, "West");
        jp.add((Component)this.countLabel, "Center");
        jp.setBackground(c);
        this.pbclose = new PictureButton("\u9690\u85cf", "skin/vistaclose.gif", "skin/vistaclose2.gif", this, this.chatApplet, "close");
        this.pbclose.setBackground(c);
        this.pbclose.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ChatTip.this.Unload();
            }
        });
        jp.add((Component)this.pbclose, "East");
        this.outBorder.add((Component)jp, "North");
        this.outBorder.add((Component)sp, "Center");
        final HTMLDocument doc = (HTMLDocument)ep.getDocument();
        ep.setText("<span id=\"zengjun741211\">&nbsp</span>");
        ep.AppendHTML(tip);
        ep.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            if (e.getURL() == null) {
                                String t = e.getDescription();
                                ChatTip.this.gotoURL(t);
                            } else {
                                String surl = e.getURL().toString();
                                ChatTip.this.gotoURL(surl);
                            }
                        }
                        catch (Exception ioe) {
                            System.out.println("Error: " + ioe);
                        }
                    }
                }
            }
        });
        double f = tip.length() / 50;
        if (f < 1.0) {
            f = 1.0;
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 180;
        int h = 150;
        this.setBounds(d.width - w, d.height - h - 30, 180, 150);
        this.setTitle(title);
        this.SetCountLabel();
        ChatTip me = this;
        Timer timer = new Timer(true);
        Counter ct = new Counter();
        timer.schedule((TimerTask)ct, 1000L, 1000L);
        ca.Beep();
    }

    public void Unload() {
        this.dispose();
    }

    public void gotoURL(String url) {
        if (url.toLowerCase().startsWith("http")) {
            this.chatApplet.MainFrame.Action_go(url);
        } else {
            this.chatApplet.MainFrame.Action_oaUrl(url);
        }
    }

    public void SetCountLabel() {
        this.countLabel.setText(" \u5728" + String.valueOf(this.RemainSecond) + "\u79d2\u540e\u81ea\u52a8\u5173\u95ed");
    }

    public void CustomView() {
        this.setUndecorated(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ChatTip.this.origin.x = e.getX();
                ChatTip.this.origin.y = e.getY();
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = ChatTip.this.getLocation();
                ChatTip.this.setLocation(p.x + e.getX() - ChatTip.this.origin.x, p.y + e.getY() - ChatTip.this.origin.y);
            }

            public void mouseMoved(MouseEvent e) {
                if (e.getX() < 20 && e.getY() < 12) {
                    ChatTip.this.countLabel.setCursor(new Cursor(12));
                } else {
                    ChatTip.this.countLabel.setCursor(new Cursor(13));
                }
            }
        });
    }

    class Counter
    extends TimerTask {
        Counter() {
        }

        public void run() {
            --ChatTip.this.RemainSecond;
            if (ChatTip.this.RemainSecond == 0) {
                ChatTip.this.Unload();
                this.cancel();
            }
            ChatTip.this.SetCountLabel();
        }
    }
}

