/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.ChatHTMLDocument;
import IM.client.ChatHTMLEditorKit;
import IM.util.Tools;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ChatPane
extends JTextPane
implements HyperlinkListener {
    ChatHTMLDocument doc;
    JPopupMenu popupMenu;
    JMenuItem mi_clear;
    JMenuItem mi_copy;
    JMenuItem mi_paste;
    ChatApplet applet;

    public ChatPane(ChatApplet ca) {
        this.applet = ca;
        this.setEditorKit(new ChatHTMLEditorKit(ca));
        this.doc = (ChatHTMLDocument)this.getDocument();
        this.setEditable(false);
        this.setContentType("text/html; charset=UTF-8");
        this.CreateRightMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    ChatPane.this.mi_paste.setEnabled(ChatPane.this.isEditable());
                    ChatPane.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void reInit(boolean editable) {
        this.setEditorKit(new ChatHTMLEditorKit(this.applet));
        this.doc = (ChatHTMLDocument)this.getDocument();
        this.setEditable(editable);
    }

    public synchronized void clear() {
    }

    private void CreateRightMenu() {
        this.popupMenu = new JPopupMenu("popup");
        this.mi_copy = new JMenuItem("\u590d\u5236", new ImageIcon(Tools.GetImageFromURL(this, "IM/res/copy.gif")));
        this.mi_paste = new JMenuItem("\u7c98\u8d34", new ImageIcon(Tools.GetImageFromURL(this, "IM/res/paste.gif")));
        this.mi_clear = new JMenuItem("\u6e05\u9664", new ImageIcon(Tools.GetImageFromURL(this, "IM/res/erase.gif")));
        this.popupMenu.add(this.mi_copy);
        this.popupMenu.add(this.mi_paste);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.mi_clear);
        this.mi_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatPane.this.copy();
            }
        });
        this.mi_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatPane.this.paste();
            }
        });
        this.mi_clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatPane.this.clear();
            }
        });
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e instanceof HTMLFrameHyperlinkEvent) {
            ((HTMLDocument)this.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
        }
    }

    public synchronized void AppendHTML(String html) {
        try {
            this.doc.insertBeforeStart(this.doc.getElement("zengjun741211"), html);
            this.moveCaretPosition(this.doc.getEndPosition().getOffset() - 1);
            this.setCaretPosition(this.doc.getEndPosition().getOffset() - 1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            try {
                this.doc.insertBeforeStart(this.doc.getElement("zengjun741211"), "<span>" + Tools.HTML2Text(html) + "/span");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void InsertHTML(String html) {
        try {
            this.doc.insertAtLeaf(this.getCaretPosition() + 1, html);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void insertSpace() {
        try {
            int caretPos = this.getCaretPosition();
            this.doc.insertString(caretPos, "\u00a0", this.getInputAttributes());
            this.setCaretPosition(caretPos + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void insertBR() {
        try {
            int caretPos = this.getCaretPosition();
            ((HTMLEditorKit)this.getEditorKit()).insertHTML(this.doc, caretPos, "<BR>", 0, 0, HTML.Tag.BR);
            this.setCaretPosition(caretPos + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Element getElement(String name) {
        return this.doc.getElement(name);
    }

    public synchronized void remove(String tag1, String tag2) {
        try {
            int p1 = this.doc.getElement(tag1).getStartOffset();
            int p2 = this.doc.getElement(tag2).getEndOffset();
            this.doc.remove(p1, p2 - p1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void insertAfterEnd(String tag, String html) {
        try {
            this.doc.insertAfterEnd(this.doc.getElement(tag), html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setInnerHTML(String tag, String html) {
        try {
            this.doc.setInnerHTML(this.doc.getElement(tag), html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

