/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.SkinFrame;
import IM.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class ChatBrowser
extends SkinFrame
implements ComponentListener {
    private ConcurrentLinkedQueue actionQueue = new ConcurrentLinkedQueue();
    private WebBrowser webBrowser;

    static {
        BrowserEngineManager bem = BrowserEngineManager.instance();
        IBrowserEngine be = bem.getActiveEngine();
        if (be == null) {
            bem.setActiveEngine(BrowserEngineManager.IE);
        }
        WebBrowser.setDebug((boolean)false);
    }

    public void componentHidden(ComponentEvent e) {
        this.popAction();
    }

    public ChatBrowser(ChatApplet applet, String title, String url, int width, int height) {
        super(applet, title, false);
        BorderLayout bl = new BorderLayout();
        this.titlePanel.pb4.command = "hide";
        this.CustomPanel.setLayout(bl);
        this.webBrowser = new WebBrowser();
        this.webBrowser.addWebBrowserListener(new WebBrowserListener(){
            boolean isFirstPage = true;

            public void downloadStarted(WebBrowserEvent event) {
            }

            public void downloadCompleted(WebBrowserEvent event) {
            }

            public void downloadProgress(WebBrowserEvent event) {
            }

            public void downloadError(WebBrowserEvent event) {
            }

            public void documentCompleted(WebBrowserEvent event) {
                URL u = ChatBrowser.this.webBrowser.getURL();
                if (u != null) {
                    String url = u.getPath();
                    if (url.endsWith("flow_im_closewindow.htm")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ChatBrowser.this.dispose();
                            }
                        });
                    }
                    ChatBrowser.this.setBrowserSizeFromURL(u.getQuery());
                }
            }

            public void titleChange(WebBrowserEvent event) {
            }

            public void statusTextChange(WebBrowserEvent event) {
            }

            public void initializationCompleted(WebBrowserEvent arg0) {
            }

            public void windowClose(WebBrowserEvent arg0) {
            }
        });
        try {
            this.webBrowser.setURL(new URL(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.CustomPanel.add((Component)this.webBrowser, "Center");
        this.setSize(new Dimension(width, height));
        this.pack();
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
        Tools.MoveToScreenRightBottom(this);
    }

    public void hide() {
        try {
            this.webBrowser.setURL(new URL(String.valueOf(this.chatApplet.HomeURL) + "blank.jsp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.hide();
    }

    public void setBrowserSizeFromURL(String param) {
        if (param == null) {
            return;
        }
        int p = param.indexOf("browserwidth=[");
        if (p >= 0) {
            int p2 = param.indexOf("]", p);
            int width = 0;
            try {
                width = Integer.valueOf(param.substring(p + 14, p2));
            }
            catch (Exception er) {
                width = 0;
            }
            int height = 0;
            p = param.indexOf("browserheight=[");
            if (p >= 0) {
                p2 = param.indexOf("]", p);
                height = 0;
                try {
                    height = Integer.valueOf(param.substring(p + 15, p2));
                }
                catch (Exception er) {
                    height = 0;
                }
            }
            if (height * width > 0) {
                this.setState(0);
                this.setExtendedState(0);
                this.setSize(new Dimension(width, height));
                Tools.MoveToScreenRightBottom(this);
            }
        }
    }

    public void open(String title, String url, int width, int height) {
        this.setTitle(title);
        this.setState(0);
        this.setExtendedState(0);
        this.setSize(new Dimension(width, height));
        Tools.MoveToScreenRightBottom(this);
        this.setVisible(true);
        try {
            this.webBrowser.setContent("<html><body><br><br><br><br><p align='center'>\u6b63\u5728\u52a0\u8f7d..</p></body></html>");
            this.webBrowser.setURL(new URL(url));
            this.doLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pushAction(String s) {
        s.startsWith(ChatApplet.ACTION_QuickReceiveWork);
        this.actionQueue.add(s);
        this.popAction();
    }

    public void popAction() {
        if (this.isVisible()) {
            return;
        }
        Object action = this.actionQueue.poll();
        if (action == null) {
            return;
        }
        this.processAction((String)action);
    }

    private void processAction(String action) {
        if (action.startsWith(ChatApplet.ACTION_QuickProcessWork)) {
            String t = action.substring(ChatApplet.ACTION_QuickProcessWork.length() + 1);
            this.chatApplet.MainFrame.Action_innerIE("flow_im_do.jsp?processid=" + t, "\u5feb\u901f\u53d7\u7406\u5de5\u4f5c", 400, 390);
        }
        if (action.startsWith(ChatApplet.ACTION_QuickReceiveWork)) {
            this.chatApplet.MainFrame.Action_innerIE("flow_im_toreceive_list.jsp", "\u5feb\u901f\u7b7e\u6536\u5de5\u4f5c", 400, 390);
        }
    }
}

