/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatAlarmTask;
import IM.client.ChatForm;
import IM.client.ChatMainFrame;
import IM.client.ChatTip;
import IM.client.Client;
import IM.client.Message;
import IM.client.MessageParser;
import IM.client.PlaySound;
import IM.client.SoundList;
import IM.client.TreeNodeData;
import IM.util.Escape;
import IM.util.Tools;
import IM.util.ZDataParser;
import appletrpc.RPC;
import appletrpc.RPCParameter;
import java.applet.AudioClip;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.UIManager;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class ChatApplet
extends JApplet
implements MessageParser {
    public static String ACTION_RefreshWorkFlow = "RefreshWorkFlow";
    public static String ACTION_RefreshMail = "RefreshMail";
    public static String ACTION_QuickReceiveWork = "QuickReceiveWork";
    public static String ACTION_QuickProcessWork = "QuickProcessWork";
    SoundList soundList;
    String loopFile = "beep.wav";
    int SoundLen = 400;
    Object loopClip;
    Client client;
    int Port;
    public boolean freeHand = true;
    public boolean chatEnabled = true;
    public String imTitle = "\u653f\u4f01\u901a";
    public ChatMainFrame MainFrame;
    public String HomeURL = "";
    public int UserID;
    public String UserName;
    public String UserShowName = "";
    public String ServerAddress = "";
    public int UserState = 1;
    public int Accounts;
    boolean running = true;
    static int FileBlockSize = 786432;
    Object loginLock = new Object();
    boolean canLogin = false;
    boolean neednotLogin = false;
    boolean sendSMSPermit = true;
    boolean logPermit = false;
    HashMap ID2ChatForm = new HashMap();
    ChatAlarmTask alarmTask;
    StringBuffer logInfo = new StringBuffer(1024);
    SimpleDateFormat SDF = new SimpleDateFormat("MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
    String thisHostAddress = "";
    public StringBuffer debugInfo = new StringBuffer();

    public ChatApplet() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void log(String s) {
        System.out.println(s);
        if (!this.logPermit) {
            return;
        }
        try {
            InetAddress[] addrs;
            if (this.thisHostAddress.equals("") && (addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())).length > 0) {
                this.thisHostAddress = String.valueOf(this.thisHostAddress) + addrs[0].getHostAddress();
            }
            RPCParameter p = new RPCParameter();
            p.put("userid", this.UserID);
            p.put("address", this.thisHostAddress);
            p.put("info", s);
            RPCParameter rPCParameter = RPC.Call(String.valueOf(this.HomeURL) + "servlet/IM.server.WiseIMLogin", "clientIMLog", p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
        try {
            this.HomeURL = this.getCodeBase().toString();
        }
        catch (Exception e) {
            this.HomeURL = "http://zengjun3:18080/wiseoa/";
        }
        if (this.HomeURL.substring(0, 4).equalsIgnoreCase("file")) {
            this.HomeURL = "http://zengjun3:18080/wiseoa/";
        }
        System.out.println(this.HomeURL);
        String s = this.getParameter("userid");
        if (s == null || s.equals("")) {
            s = "1";
        }
        try {
            this.UserID = new Integer(s);
        }
        catch (Exception e) {
            this.UserID = 0;
        }
        s = this.getParameter("soundlen");
        if (s == null || s.equals("")) {
            s = "400";
        }
        try {
            this.SoundLen = new Integer(s);
        }
        catch (Exception e) {
            this.SoundLen = 400;
        }
        s = this.getParameter("username");
        if (s == null || s.equals("")) {
            s = "wise";
        }
        this.UserName = s;
        s = this.getParameter("showname");
        if (s == null || s.equals("")) {
            s = "wise";
        }
        this.UserShowName = s;
        s = this.getParameter("data");
        s = Tools.DecryptString(s, "abcdefghijklmnopqrstuvwxyz");
        try {
            this.Port = new Integer(s);
        }
        catch (Exception e) {
            this.Port = 4900;
        }
        JButton cb = new JButton("chat");
        this.getContentPane().add(cb);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatApplet.this.ShowChatFrame(true);
            }
        });
        try {
            this.soundList = new SoundList(this, new URL(String.valueOf(this.HomeURL) + "snd/"));
            this.soundList.startLoading(this.loopFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(String homeURL, int userid, String username, String showname, int port, String server, int soundLen) {
        this.HomeURL = homeURL;
        this.UserID = userid;
        this.SoundLen = soundLen;
        this.UserName = username;
        this.UserShowName = showname;
        this.ServerAddress = server;
        this.Port = port;
        try {
            this.soundList = new SoundList(this, new URL(String.valueOf(this.HomeURL) + "snd/"));
            this.soundList.startLoading(this.loopFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Beep() {
        try {
            if (this.loopClip == null) {
                this.loopClip = this.soundList.getClip(this.loopFile);
            }
            if (this.loopClip instanceof AudioClip) {
                PlaySound ps = new PlaySound((AudioClip)this.loopClip, this.SoundLen);
                ps.start();
            }
            if (this.loopClip instanceof ContinuousAudioDataStream) {
                ContinuousAudioDataStream ca = (ContinuousAudioDataStream)this.loopClip;
                ca.reset();
                AudioPlayer.player.start((InputStream)ca);
                Thread.sleep(this.SoundLen);
                AudioPlayer.player.stop((InputStream)ca);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void Close() {
        try {
            try {
                this.running = false;
                if (this.alarmTask != null) {
                    this.alarmTask.cancel();
                    this.alarmTask = null;
                }
                if (this.client != null && this.client.isConnected()) {
                    ArrayList idList = new ArrayList();
                    this.SendMessage(400, idList, "");
                    Thread.sleep(100L);
                    this.client.close();
                    this.client = null;
                }
            }
            catch (Exception exception) {
                this.client = null;
            }
        }
        finally {
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean Connect() {
        this.Close();
        try {
            this.log(String.valueOf(this.UserShowName) + "\u6b63\u5728\u8fde\u63a5\u670d\u52a1\u5668...");
            if (this.ServerAddress.equals("")) {
                this.ServerAddress = "zengjun3";
            }
            this.client = new Client(this, this, this.Port, this.ServerAddress);
            if (!this.client.connect()) throw new Exception("\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668");
            this.log(String.valueOf(this.UserShowName) + "\u4e0e\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f\uff0c\u5411\u670d\u52a1\u5668\u62a5\u544a\u6211\u7684IP\u5730\u5740\uff0c\u5e76\u7b49\u5f85\u670d\u52a1\u5668\u56de\u590d");
            ZDataParser dp = new ZDataParser();
            dp.put("userid", this.UserID);
            dp.put("homeurl", this.HomeURL);
            Object object = this.loginLock;
            synchronized (object) {
                this.log("\u7b49\u5f85\u56de\u590d");
                try {
                    this.canLogin = false;
                    this.neednotLogin = false;
                    this.SendMessage(10, null, dp.toString());
                    this.loginLock.wait(10000L);
                }
                catch (Exception e) {
                    this.log(e.getMessage());
                    throw e;
                }
            }
            if (this.neednotLogin) {
                this.log("\u670d\u52a1\u5668\u62d2\u7edd\u4e86\u6211\u7684\u767b\u5f55");
                return false;
            }
            if (!this.canLogin) {
                this.log("\u670d\u52a1\u5668\u6ca1\u6709\u54cd\u5e94\uff0c30\u79d2\u540e\u518d\u6b21\u7533\u8bf7\u767b\u5f55");
                Thread.sleep(30000L);
                object = this.loginLock;
                synchronized (object) {
                    try {
                        System.out.println("\u7b49\u5f85\u56de\u590d");
                        this.canLogin = false;
                        this.neednotLogin = false;
                        this.SendMessage(390, null, dp.toString());
                        this.loginLock.wait(60000L);
                    }
                    catch (Exception e) {
                        this.log(e.getMessage());
                        throw e;
                    }
                }
                if (this.neednotLogin) {
                    return false;
                }
                if (!this.canLogin) {
                    this.log("\u670d\u52a1\u5668\u6ca1\u6709\u54cd\u5e94");
                    throw new Exception("\u670d\u52a1\u5668\u6ca1\u6709\u54cd\u5e94");
                }
            }
            this.running = true;
            return true;
        }
        catch (Exception e) {
            String s = e.getMessage();
            if (s.equals("")) {
                s = "\u8bf7\u91cd\u65b0\u767b\u5f55";
            }
            this.log(s);
            try {
                Thread.sleep(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.Close();
            return false;
        }
    }

    public void ShowInfo(String s, int delay) {
        this.Alarm("<img src='" + this.HomeURL + "image/systemtip.jpg'><br>" + s, 0, 0, delay);
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean Tray) {
        this.MainFrame = new ChatMainFrame(this, Tray);
        this.MainFrame.loadLastLoginInfo();
    }

    public void destroy() {
        this.Close();
        this.MainFrame.dispose();
        super.destroy();
    }

    public void ShowChatFrame(boolean b) {
        this.MainFrame.setVisible(true);
    }

    public static void main(String[] args) {
        ChatApplet applet = new ChatApplet();
        String homeurl = "http://zengjun3:18080/wiseoa/";
        int userid = -9999;
        String username = "wangxy00";
        String showname = "";
        int port = 0;
        String pwd = "1234";
        String server = homeurl;
        int soundLen = 400;
        if (args.length > 0) {
            homeurl = args[0];
        }
        if (args.length > 1) {
            try {
                userid = new Integer(args[1]);
            }
            catch (Exception e) {
                userid = -9999;
            }
        }
        if (args.length > 2) {
            username = args[2];
        }
        if (args.length > 3) {
            showname = Escape.unescape(args[3]);
        }
        if (args.length > 4) {
            try {
                port = new Integer(args[4]);
            }
            catch (Exception e) {
                port = 4900;
            }
        }
        if (args.length > 5) {
            pwd = Tools.DecryptString(Escape.unescape(args[5]), "zengjun-");
        }
        if (args.length > 6) {
            server = args[6];
        }
        if (args.length > 7) {
            try {
                soundLen = new Integer(args[7]);
            }
            catch (Exception e) {
                soundLen = 400;
            }
        }
        boolean freeHand = args.length > 8 ? Boolean.valueOf(args[8]) : true;
        if (args.length > 9) {
            applet.imTitle = Escape.unescape(args[9]);
        }
        boolean chatEnabled = args.length > 10 ? Boolean.valueOf(args[10]) : true;
        applet.init(homeurl, userid, username, showname, port, server, soundLen);
        applet.freeHand = freeHand;
        applet.chatEnabled = chatEnabled;
        applet.start(true);
        applet.ShowChatFrame(true);
        applet.MainFrame.ExitOnExit = true;
        int i = 0;
        while (i < args.length) {
            ++i;
        }
        if (userid >= 0) {
            applet.MainFrame.jb_login.setVisible(false);
            applet.MainFrame.sle_name.setText(username);
            applet.MainFrame.sle_pwd.setText(pwd);
            applet.MainFrame.login(username, pwd);
        } else {
            applet.MainFrame.st_login.setVisible(false);
            applet.MainFrame.loadLastLoginInfo();
        }
    }

    private void CMD_NotifyClientSomeoneState(Message m) {
        int i = 0;
        while (i < m.msgReceiver.size()) {
            int userid = (Integer)m.msgReceiver.get(i);
            String state = m.ExtractValue(String.valueOf(userid));
            if (this.MainFrame != null) {
                this.MainFrame.SomeOneState(userid, new Integer(state));
            }
            ++i;
        }
    }

    private void CMD_CanNotFeedback(Message m) {
        String tip = String.valueOf(TreeNodeData.ID2ShowName(m.msgSender)) + m.msgBody;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        idList.add(new Integer(m.msgSender));
        ChatForm cf = this.FindChatForm(idList);
        if (cf == null) {
            return;
        }
        cf.BeepIfNeed(false);
    }

    private void CMD_ReceiveMessage(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                if (sender == null) {
                    sender = "";
                }
                if (sender.equals("\u7cfb\u7edf\u4fe1\u4f7f")) {
                    this.Alarm("<img src='" + this.HomeURL + "image/systemtip.jpg'><br>" + m.msgBody, 700, 550);
                } else {
                    nameList.add(sender);
                    cf = new ChatForm(this, idList, nameList);
                }
            }
            if (cf != null) {
                cf.BeepIfNeed(true);
                cf.ReceiveMessage(m);
            }
        }
    }

    private void CMD_ReceiveAction(Message m) {
        if (m.msgBody.equals(ACTION_RefreshWorkFlow)) {
            this.MainFrame.Action_RefreshWorkFlowCount();
        }
        if (m.msgBody.equals(ACTION_RefreshMail)) {
            this.MainFrame.Action_RefreshWorkFlowCount();
        }
        if (m.msgBody.startsWith(ACTION_QuickProcessWork)) {
            this.MainFrame.chatBrowser.pushAction(m.msgBody);
        }
        if (m.msgBody.equals(ACTION_QuickReceiveWork)) {
            this.MainFrame.chatBrowser.pushAction(m.msgBody);
        }
    }

    private void CMD_KeyTyped(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                return;
            }
            cf.BeepIfNeed(false);
            cf.SomeKeyTyped(m);
        }
    }

    private void CMD_SendFile(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(true);
                cf.SomeOneWantSendFileToMe(m);
            }
        }
    }

    private void CMD_SendFileCancel(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SomeOneCancelSendFileToMe(m);
            }
        }
    }

    private void CMD_SendFileHalt(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SomeOneHaltSendFile(m);
            }
        }
    }

    private void CMD_SendFileReject(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SomeOneRejectMySendFile(m);
            }
        }
    }

    private void CMD_SendFileAccept(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SomeOneAcceptMySendFile(m);
            }
        }
    }

    private void CMD_SendFileAutoAccept(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SomeOneAutoAcceptMySendFile(m);
            }
        }
    }

    private void CMD_SendFileRedirectToKnowledgeBase(Message m) {
        if (m.msgReceiver.size() == 1) {
            Integer from = (Integer)m.msgReceiver.get(0);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(from);
            ChatForm cf = this.FindChatForm(idList);
            if (cf == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                String sender = (String)m.msgTag.get("sender-name");
                nameList.add(sender);
                cf = new ChatForm(this, idList, nameList);
            }
            if (cf != null) {
                cf.BeepIfNeed(false);
                cf.SendFileRedirectToKnowledgeBase(m);
            }
        }
    }

    private void CMD_ServerShutdown(Message e) {
        if (this.MainFrame.ExitOnExit) {
            this.MainFrame.logout();
            this.MainFrame.popShow();
        } else {
            this.Close();
        }
    }

    private void CMD_BeforcedIntoShutdown(Message m) {
        try {
            this.log("\u670d\u52a1\u5668\u8be2\u95ee\u5ba2\u6237\u673a\uff0c\u662f\u5426\u5141\u8bb8\u767b\u5f55\uff1a");
            HashMap tag = m.msgTag;
            String newHostName = tag.get("hostname").toString();
            String newHostAddress = tag.get("hostaddress").toString();
            this.log("\u8ba1\u7b97\u673a\u540d\u79f0\uff1a" + newHostName);
            this.log("\u8ba1\u7b97\u673aIP\uff1a" + newHostAddress);
            InetAddress[] addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            boolean isOnSelf = false;
            int i = 0;
            while (i < addrs.length) {
                this.log("\u672c\u673a\u540d\u79f0\uff1a" + addrs[i].getHostName());
                this.log("\u672c\u673aIP\uff1a" + addrs[i].getHostAddress());
                if (newHostAddress.equalsIgnoreCase(addrs[i].getHostAddress()) && newHostName.equalsIgnoreCase(addrs[i].getHostName())) {
                    isOnSelf = true;
                }
                ++i;
            }
            if (!isOnSelf) {
                ArrayList<Integer> TO = new ArrayList<Integer>();
                TO.add(new Integer(this.UserID));
                this.SendMessage(270, TO, "");
                this.log("\u9700\u8981\u5728\u53e6\u4e00\u53f0\u673a\u5b50\u4e0a\u767b\u5f55\uff0c\u6211\u88ab\u5f3a\u5236\u9000\u51fa\uff0c\u5141\u8bb8\u5728\u65b0\u7684\u5730\u65b9\u767b\u5f55");
                if (this.MainFrame.ExitOnExit) {
                    this.MainFrame.logout();
                } else {
                    this.Close();
                }
                this.MainFrame.popShow();
                this.ShowInfo("\u5df2\u7ecf\u5728\u53e6\u4e00\u53f0\u8ba1\u7b97\u673a\u4e0a\u767b\u5f55\u4e86\u3002", 3600);
            } else {
                ArrayList<Integer> TO = new ArrayList<Integer>();
                TO.add(new Integer(this.UserID));
                this.SendMessage(290, TO, "");
                this.log("\u5728\u540c\u4e00\u53f0\u673a\u5b50\u4e0a\u5df2\u7ecf\u767b\u5f55\uff0c\u62d2\u7edd\u91cd\u590d\u767b\u5f55");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CMD_YouCanLogin(Message m) {
        this.log("\u56de\u590d");
        Object object = this.loginLock;
        synchronized (object) {
            this.canLogin = true;
            this.neednotLogin = false;
            this.loginLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CMD_YouNeednotLogin(Message m) {
        Object object = this.loginLock;
        synchronized (object) {
            this.canLogin = false;
            this.neednotLogin = true;
            this.loginLock.notify();
        }
    }

    public void parseMessage(Message m) {
        this.log(m.toString());
        try {
            switch (m.msgType) {
                case 0: {
                    break;
                }
                case 30: {
                    this.CMD_NotifyClientSomeoneState(m);
                    break;
                }
                case 80: {
                    this.MainFrame.RefreshAllState(m);
                    break;
                }
                case 100: {
                    this.CMD_CanNotFeedback(m);
                    break;
                }
                case 110: {
                    this.CMD_ReceiveMessage(m);
                    break;
                }
                case 240: {
                    this.CMD_ReceiveAction(m);
                    break;
                }
                case 220: {
                    this.CMD_KeyTyped(m);
                    break;
                }
                case 140: {
                    this.CMD_SendFile(m);
                    break;
                }
                case 150: {
                    this.CMD_SendFileCancel(m);
                    break;
                }
                case 190: {
                    this.CMD_SendFileHalt(m);
                    break;
                }
                case 170: {
                    this.CMD_SendFileReject(m);
                    break;
                }
                case 160: {
                    this.CMD_SendFileAccept(m);
                    break;
                }
                case 250: 
                case 370: {
                    this.CMD_SendFileAutoAccept(m);
                    break;
                }
                case 380: {
                    this.CMD_SendFileRedirectToKnowledgeBase(m);
                    break;
                }
                case 310: {
                    this.CMD_ServerShutdown(m);
                    break;
                }
                case 260: {
                    this.CMD_BeforcedIntoShutdown(m);
                    break;
                }
                case 280: {
                    this.CMD_YouCanLogin(m);
                    break;
                }
                case 300: {
                    this.CMD_YouNeednotLogin(m);
                }
            }
        }
        catch (Exception er) {
            er.printStackTrace();
            System.out.println("ParseMessage Error:" + er.getMessage());
        }
    }

    private String SendMessage(Message msg) {
        if (this.client != null) {
            return this.client.sendMessage(msg);
        }
        return "\u4fe1\u606f\u65e0\u6cd5\u53d1\u9001\uff0c\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u8bf7\u5148\u767b\u5f55";
    }

    public String SendMessage(int type, ArrayList receive, String msg) {
        Message m = new Message(type, this.UserID, receive, msg);
        m.msgTag.put("sender-name", this.UserName);
        return this.SendMessage(m);
    }

    public String SendMessage(int type, ArrayList receive, String msg, HashMap otherData) {
        Message m = new Message(type, this.UserID, receive, msg);
        m.msgTag.put("sender-name", this.UserName);
        Iterator it = otherData.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            m.msgTag.put(key, otherData.get(key));
        }
        return this.SendMessage(m);
    }

    public void PopupTip(String tip) {
        this.Alarm(tip, 700, 550, 5);
    }

    public void RegisterCharForm(Integer ID, ChatForm cf) {
        ArrayList<ChatForm> list = (ArrayList<ChatForm>)this.ID2ChatForm.get(ID);
        if (list == null) {
            list = new ArrayList<ChatForm>();
            this.ID2ChatForm.put(ID, list);
        }
        if (!list.contains(cf)) {
            list.add(cf);
        }
    }

    public void UnRegisterCharForm(Integer ID, ChatForm cf) {
        ArrayList list = (ArrayList)this.ID2ChatForm.get(ID);
        if (list == null) {
            return;
        }
        if (list.contains(cf)) {
            list.remove(cf);
        }
    }

    public ChatForm FindChatForm(ArrayList idlist) {
        int i = 0;
        while (i < idlist.size()) {
            ArrayList list = (ArrayList)this.ID2ChatForm.get((Integer)idlist.get(i));
            if (list == null) {
                return null;
            }
            int j = 0;
            while (j < list.size()) {
                ChatForm cf = (ChatForm)list.get(j);
                if (cf.SendToIDList.containsAll(idlist)) {
                    return cf;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void Alarm(ArrayList ds) {
        try {
            int i = 0;
            while (i < ds.size()) {
                HashMap map = (HashMap)ds.get(i);
                Object t = map.get("bychat");
                if (t != null && new Integer(t.toString()) == 1) {
                    String info = (String)map.get("alarm_info");
                    this.Alarm(info, 100 + i * 50, 100 + i * 50);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void Alarm(String info, int x, int y) {
        this.Alarm(info, x, y, 15);
    }

    public void Alarm(String info, int x, int y, int delay) {
        String sign1 = "@wisesoft@im@openurl@";
        String sign2 = "@wisesoft@im@openoaurl@";
        if (info.indexOf(sign1) > 0) {
            info = info.substring(info.indexOf(sign1) + sign1.length());
            this.MainFrame.Action_go(info);
            return;
        }
        if (info.indexOf(sign2) > 0) {
            if ((info = info.substring(info.indexOf(sign2) + sign2.length())).startsWith(this.HomeURL)) {
                info = info.substring(this.HomeURL.length());
            }
            this.MainFrame.Action_oaUrl(info);
            return;
        }
        ChatTip ct = new ChatTip("\u7cfb\u7edf\u63d0\u9192", info, delay, this.HomeURL, this);
        if (x != 0 && y != 0) {
            Rectangle rc = ct.getBounds();
            rc.x = x;
            rc.y = y;
            ct.setBounds(rc);
        }
        ct.setVisible(true);
    }

    public void UploadFileToMyFolder(String toPath) {
        this.MainFrame.UploadFileToMyFolder(toPath);
    }

    public void catchException(Throwable e) {
        try {
            System.out.println(e.getClass().getName());
            this.MainFrame.popShow();
            String s = e.getMessage();
            this.MainFrame.logout();
            if (e instanceof ClosedChannelException || e instanceof IOException) {
                if (s == null) {
                    s = "";
                }
                s = String.valueOf(s) + "<br>" + this.imTitle + "\u5c06\u572860\u79d2\u540e\u81ea\u52a8\u91cd\u65b0\u767b\u5f55\u3002";
                System.out.println("5\u79d2\u540e\u91cd\u8fde");
                Thread.sleep(5000L);
                if (this.MainFrame.autoReLogin()) {
                    // empty if block
                }
                this.client.reSendLastMessage();
            } else if (s != null) {
                this.ShowInfo(s, 60);
            }
        }
        catch (Exception er) {
            System.out.println(er.getMessage());
        }
    }

    public void pingServer() {
        this.SendMessage(320, null, "");
    }
}

