/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatForm;
import IM.client.States;
import IM.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class CaptureScreen {
    ChatForm pForm;
    private BufferedImage get;
    Temp temp;
    Dimension di;

    public CaptureScreen(ChatForm a) {
        this.pForm = a;
    }

    public void doStart() {
        try {
            Thread.sleep(500L);
            Robot ro = new Robot();
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.di = tk.getScreenSize();
            Rectangle rec = new Rectangle(0, 0, this.di.width, this.di.height);
            BufferedImage bi = ro.createScreenCapture(rec);
            JFrame jf = new JFrame();
            this.temp = new Temp(jf, bi, this.di.width, this.di.height);
            jf.getContentPane().add((Component)this.temp, "Center");
            jf.setUndecorated(true);
            jf.setSize(this.di);
            jf.setVisible(true);
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    private class Temp
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private ToolWindow tools = null;
        private BufferedImage bi;
        private BufferedImage ti;
        private int width;
        private int height;
        private int startX;
        private int startY;
        private int endX;
        private int endY;
        private int tempX;
        private int tempY;
        private JFrame jf;
        private Rectangle select = new Rectangle(0, 0, 0, 0);
        private Cursor cs = new Cursor(1);
        private States current = States.DEFAULT;
        private Rectangle[] rec;
        public static final int START_X = 1;
        public static final int START_Y = 2;
        public static final int END_X = 3;
        public static final int END_Y = 4;
        private int currentX;
        private int currentY;
        private Point p = new Point();
        private boolean showTip = true;

        public Temp(JFrame jf, BufferedImage bi, int width, int height) {
            this.jf = jf;
            this.bi = bi;
            RescaleOp ro = new RescaleOp(0.8f, 0.0f, null);
            this.ti = ro.filter(bi, null);
            this.width = width;
            this.height = height;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.initRecs();
        }

        private void initRecs() {
            this.rec = new Rectangle[8];
            int i = 0;
            while (i < this.rec.length) {
                this.rec[i] = new Rectangle();
                ++i;
            }
        }

        public void onOK() {
            this.getSelection();
            this.doCopy(CaptureScreen.this.get);
            this.jf.dispose();
            CaptureScreen.this.pForm.setVisible(true);
            CaptureScreen.this.pForm.ep_info.paste();
        }

        public void onCancel() {
            this.jf.dispose();
            CaptureScreen.this.pForm.setVisible(true);
        }

        public void doCopy(final BufferedImage image) {
            try {
                if (CaptureScreen.this.get == null) {
                    JOptionPane.showMessageDialog(null, "\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a!!", "\u9519\u8bef", 0);
                    return;
                }
                Transferable trans = new Transferable(){

                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{DataFlavor.imageFlavor};
                    }

                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return DataFlavor.imageFlavor.equals(flavor);
                    }

                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        if (this.isDataFlavorSupported(flavor)) {
                            return image;
                        }
                        throw new UnsupportedFlavorException(flavor);
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
            }
            catch (Exception exe) {
                exe.printStackTrace();
                JOptionPane.showMessageDialog(null, "\u590d\u5236\u5230\u7cfb\u7edf\u7c98\u5e16\u677f\u51fa\u9519!!", "\u9519\u8bef", 0);
            }
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.ti, 0, 0, this.width, this.height, this);
            if (this.endX != this.startX && this.endY != this.startY) {
                BufferedImage tti = this.bi.getSubimage(Math.min(this.startX, this.endX), Math.min(this.startY, this.endY), Math.abs(this.endX - this.startX), Math.abs(this.endY - this.startY));
                g.drawImage(tti, Math.min(this.startX, this.endX), Math.min(this.startY, this.endY), null);
            }
            g.setColor(Color.BLUE);
            g.drawLine(this.startX, this.startY, this.endX, this.startY);
            g.drawLine(this.startX, this.endY, this.endX, this.endY);
            g.drawLine(this.startX, this.startY, this.startX, this.endY);
            g.drawLine(this.endX, this.startY, this.endX, this.endY);
            int x = this.startX < this.endX ? this.startX : this.endX;
            int y = this.startY < this.endY ? this.startY : this.endY;
            this.select = new Rectangle(x, y, Math.abs(this.endX - this.startX), Math.abs(this.endY - this.startY));
            int x1 = (this.startX + this.endX) / 2;
            int y1 = (this.startY + this.endY) / 2;
            g.fillRect(x1 - 2, this.startY - 2, 5, 5);
            g.fillRect(x1 - 2, this.endY - 2, 5, 5);
            g.fillRect(this.startX - 2, y1 - 2, 5, 5);
            g.fillRect(this.endX - 2, y1 - 2, 5, 5);
            g.fillRect(this.startX - 2, this.startY - 2, 5, 5);
            g.fillRect(this.startX - 2, this.endY - 2, 5, 5);
            g.fillRect(this.endX - 2, this.startY - 2, 5, 5);
            g.fillRect(this.endX - 2, this.endY - 2, 5, 5);
            this.rec[0] = new Rectangle(x - 5, y - 5, 10, 10);
            this.rec[1] = new Rectangle(x1 - 5, y - 5, 10, 10);
            this.rec[2] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, y - 5, 10, 10);
            this.rec[3] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, y1 - 5, 10, 10);
            this.rec[4] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[5] = new Rectangle(x1 - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[6] = new Rectangle(x - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[7] = new Rectangle(x - 5, y1 - 5, 10, 10);
            if (this.showTip) {
                g.setColor(Color.white);
                g.fillRect(this.p.x + 2, this.p.y + 2, 200, 20);
                g.setColor(Color.BLACK);
                g.drawString("\u6309\u4e0b\u5de6\u952e\u62d6\u52a8\u9009\u62e9\u622a\u56fe\u533a\uff0c\u53f3\u952e\u653e\u5f03", this.p.x + 2, this.p.y + 16);
            }
        }

        private void initSelect(States state) {
            switch (state) {
                case DEFAULT: {
                    this.currentX = 0;
                    this.currentY = 0;
                    break;
                }
                case EAST: {
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    this.currentY = 0;
                    break;
                }
                case WEST: {
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    this.currentY = 0;
                    break;
                }
                case NORTH: {
                    this.currentX = 0;
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    break;
                }
                case SOUTH: {
                    this.currentX = 0;
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    break;
                }
                case NORTH_EAST: {
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    break;
                }
                case NORTH_WEST: {
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    break;
                }
                case SOUTH_EAST: {
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    break;
                }
                case SOUTH_WEST: {
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    break;
                }
                default: {
                    this.currentX = 0;
                    this.currentY = 0;
                }
            }
        }

        public void mouseMoved(MouseEvent me) {
            this.doMouseMoved(me);
            this.initSelect(this.current);
            if (this.showTip) {
                this.p = me.getPoint();
                this.repaint();
            }
        }

        private void doMouseMoved(MouseEvent me) {
            if (this.select.contains(me.getPoint())) {
                this.setCursor(new Cursor(13));
                this.current = States.MOVE;
            } else {
                States[] st = States.values();
                int i = 0;
                while (i < this.rec.length) {
                    if (this.rec[i].contains(me.getPoint())) {
                        this.current = st[i];
                        this.setCursor(st[i].getCursor());
                        return;
                    }
                    ++i;
                }
                this.setCursor(this.cs);
                this.current = States.DEFAULT;
            }
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            if (this.current == States.MOVE) {
                this.startX += x - this.tempX;
                this.startY += y - this.tempY;
                this.endX += x - this.tempX;
                this.endY += y - this.tempY;
                this.tempX = x;
                this.tempY = y;
            } else if (this.current == States.EAST || this.current == States.WEST) {
                if (this.currentX == 1) {
                    this.startX += x - this.tempX;
                    this.tempX = x;
                } else {
                    this.endX += x - this.tempX;
                    this.tempX = x;
                }
            } else if (this.current == States.NORTH || this.current == States.SOUTH) {
                if (this.currentY == 2) {
                    this.startY += y - this.tempY;
                    this.tempY = y;
                } else {
                    this.endY += y - this.tempY;
                    this.tempY = y;
                }
            } else if (this.current == States.NORTH_EAST || this.current == States.NORTH_EAST || this.current == States.SOUTH_EAST || this.current == States.SOUTH_WEST) {
                if (this.currentY == 2) {
                    this.startY += y - this.tempY;
                    this.tempY = y;
                } else {
                    this.endY += y - this.tempY;
                    this.tempY = y;
                }
                if (this.currentX == 1) {
                    this.startX += x - this.tempX;
                    this.tempX = x;
                } else {
                    this.endX += x - this.tempX;
                    this.tempX = x;
                }
            } else {
                this.startX = this.tempX;
                this.startY = this.tempY;
                this.endX = me.getX();
                this.endY = me.getY();
            }
            this.repaint();
        }

        public void mousePressed(MouseEvent me) {
            this.showTip = false;
            this.tempX = me.getX();
            this.tempY = me.getY();
            if (this.tools != null) {
                this.tools.setVisible(false);
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                if (this.current == States.MOVE) {
                    this.showTip = true;
                    this.p = me.getPoint();
                    this.startX = 0;
                    this.startY = 0;
                    this.endX = 0;
                    this.endY = 0;
                    this.repaint();
                } else {
                    this.jf.dispose();
                }
            }
            if (this.tools == null) {
                this.tools = new ToolWindow(this.jf, Math.max(10, Math.max(this.startX, this.endX) - 100), Math.max(this.startY, this.endY) + 10);
            } else {
                this.tools.setLocation(Math.max(10, Math.max(this.startX, this.endX) - 100), Math.max(this.startY, this.endY) + 10);
            }
            if (Math.max(this.startY, this.endY) > CaptureScreen.this.di.height - 34) {
                this.tools.setLocation(this.tools.getLocation().x, Math.min(this.startY, this.endY) - 10 - 24);
            }
            this.tools.setVisible(true);
            this.tools.toFront();
        }

        public void getSelection() {
            if (this.select.x + this.select.width < this.getWidth() && this.select.y + this.select.height < this.getHeight()) {
                CaptureScreen.this.get = this.bi.getSubimage(this.select.x, this.select.y, this.select.width, this.select.height);
                this.jf.dispose();
            } else {
                int wid = this.select.width;
                int het = this.select.height;
                if (this.select.x + this.select.width >= this.getWidth()) {
                    wid = this.getWidth() - this.select.x;
                }
                if (this.select.y + this.select.height >= this.getHeight()) {
                    het = this.getHeight() - this.select.y;
                }
                CaptureScreen.this.get = this.bi.getSubimage(this.select.x, this.select.y, wid, het);
                this.jf.dispose();
            }
        }

        public void mouseClicked(MouseEvent me) {
            Point p;
            if (me.getClickCount() == 2 && this.select.contains(p = me.getPoint())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Temp.this.onOK();
                    }
                });
            }
        }
    }

    class ToolWindow
    extends JWindow {
        private static final long serialVersionUID = 1L;

        public ToolWindow(JFrame parent, int x, int y) {
            super(parent);
            this.init();
            this.setLocation(x, y);
            this.pack();
            this.setVisible(true);
        }

        private void init() {
            this.setLayout(new BorderLayout());
            JToolBar toolBar = new JToolBar("Java\u622a\u56fe");
            JButton saveButton = new JButton(new ImageIcon(Tools.GetImageFromURL(CaptureScreen.this.pForm.chatApplet, "IM/res/ok-green.png")));
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ToolWindow)(this).ToolWindow.this).CaptureScreen.this.temp.onOK();
                        }
                    });
                }
            });
            toolBar.add(saveButton);
            JButton closedButton = new JButton(new ImageIcon(Tools.GetImageFromURL(CaptureScreen.this.pForm.chatApplet, "IM/res/cancel.png")));
            closedButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ToolWindow)(this).ToolWindow.this).CaptureScreen.this.temp.onCancel();
                        }
                    });
                }
            });
            toolBar.add(closedButton);
            this.add((Component)toolBar, "North");
        }
    }
}

