/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import sos.preview.core.Scaleable;

class LayoutSupport {
    private Container container;
    private double maxComponentFixedWidth;
    private double maxComponentFixedHeight;
    private double maxComponentScaledWidth;
    private double maxComponentScaledHeight;
    private double[] fixedWidth;
    private double[] fixedHeight;
    private double[] scaledWidth;
    private double[] scaledHeight;

    private LayoutSupport(Container container1) {
        this.container = container1;
        Component[] acomponent = container1.getComponents();
        int i = acomponent.length;
        this.fixedWidth = new double[i];
        this.fixedHeight = new double[i];
        this.scaledWidth = new double[i];
        this.scaledHeight = new double[i];
        this.maxComponentFixedWidth = 0.0;
        this.maxComponentFixedHeight = 0.0;
        this.maxComponentScaledWidth = 0.0;
        this.maxComponentScaledHeight = 0.0;
        int j = 0;
        while (j < i) {
            double d3;
            double d2;
            double d1;
            double d;
            Component component = acomponent[j];
            if (component instanceof Scaleable) {
                Scaleable scaleable = (Scaleable)((Object)component);
                Dimension dimension1 = scaleable.getScaleablePreferredSize();
                d = dimension1.getWidth();
                d1 = dimension1.getHeight();
                d2 = scaleable.getFixedWidth();
                d3 = scaleable.getFixedHeight();
            } else if (component instanceof Container) {
                Container container2 = (Container)component;
                Insets insets = container2.getInsets();
                d2 = insets.left + insets.right;
                d3 = insets.top + insets.bottom;
                Dimension dimension2 = container2.getPreferredSize();
                d = dimension2.getWidth() - d2;
                d1 = dimension2.getHeight() - d3;
            } else {
                d2 = 0.0;
                d3 = 0.0;
                Dimension dimension = component.getPreferredSize();
                d = dimension.getWidth();
                d1 = dimension.getHeight();
            }
            this.fixedWidth[j] = d2;
            this.fixedHeight[j] = d3;
            this.scaledWidth[j] = d;
            this.scaledHeight[j] = d1;
            this.maxComponentFixedWidth = Math.max(this.maxComponentFixedWidth, d2);
            this.maxComponentFixedHeight = Math.max(this.maxComponentFixedHeight, d3);
            this.maxComponentScaledWidth = Math.max(this.maxComponentScaledWidth, d);
            this.maxComponentScaledHeight = Math.max(this.maxComponentScaledHeight, d1);
            ++j;
        }
    }

    Dimension getPreferredLayoutSize(int i, int j, int k, int l, int i1, int j1) {
        double d = this.maxComponentFixedWidth + this.maxComponentScaledWidth;
        double d1 = this.maxComponentScaledHeight + this.maxComponentScaledHeight;
        int k1 = this.container.getComponentCount();
        double d2 = (double)(2 * i1) + (double)k1 * d + (double)((k1 - 1) * k);
        double d3 = (double)(2 * j1) + d1;
        return new Dimension((int)d2, (int)d3);
    }

    static LayoutSupport getSupport(Container container1) {
        return new LayoutSupport(container1);
    }

    double getMaximumFixedHeight() {
        return this.maxComponentFixedHeight;
    }

    double getMaximumFixedWidth() {
        return this.maxComponentFixedWidth;
    }

    double getMaximumPreferredScaleableHeight() {
        return this.maxComponentScaledHeight;
    }

    double getMaximumPreferredScaleableWidth() {
        return this.maxComponentScaledWidth;
    }

    Dimension getDimensions(double d, int i, int j, int k, int l, int i1, int j1, int k1, int l1) {
        int k3;
        int j3;
        double d1 = this.maxComponentFixedWidth + this.maxComponentScaledWidth * d;
        double d2 = this.maxComponentFixedHeight + this.maxComponentScaledHeight * d;
        int i2 = this.container.getComponentCount();
        int j2 = i * j;
        int k2 = i2 / j2;
        if (i2 % j2 != 0) {
            ++k2;
        }
        int l2 = (int)((double)i1 + (double)j * d1 + (double)((j - 1) * k) + (double)j1);
        int i3 = (int)((double)k1 + (double)i * d2 + (double)((i - 1) * l));
        ComponentOrientation componentorientation = this.container.getComponentOrientation();
        if (componentorientation.isHorizontal()) {
            j3 = l2;
            k3 = i3 * k2;
        } else {
            j3 = l2 * k2;
            k3 = i3;
        }
        Insets insets = this.container.getInsets();
        int l3 = j3 + insets.left + insets.right;
        int i4 = k3 + insets.top + insets.bottom;
        return new Dimension(l3, i4);
    }

    Dimension getLinearDimensions(double d, int i, int j, int k, int l, int i1, int j1) {
        double d4;
        double d3;
        double d1 = this.maxComponentFixedWidth + this.maxComponentScaledWidth * d;
        double d2 = this.maxComponentFixedHeight + this.maxComponentScaledHeight * d;
        int k1 = this.container.getComponentCount();
        ComponentOrientation componentorientation = this.container.getComponentOrientation();
        if (componentorientation.isHorizontal()) {
            d3 = (double)(k + l) + (double)k1 * d1 + (double)((k1 - 1) * i);
            d4 = (double)(i1 + j1) + d2;
        } else {
            d3 = (double)(k + l) + d1;
            d4 = (double)(i1 + j1) + (double)k1 * d2 + (double)((k1 - 1) * j);
        }
        Insets insets = this.container.getInsets();
        int l1 = (int)d3 + insets.left + insets.right;
        int i2 = (int)d4 + insets.top + insets.bottom;
        return new Dimension(l1, i2);
    }

    void layoutComponents(int i, int j, int k, int l, double d, int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2) {
        Component[] acomponent = this.container.getComponents();
        int i3 = acomponent.length;
        if (i3 == 0) {
            return;
        }
        ComponentOrientation componentorientation = this.container.getComponentOrientation();
        Insets insets = this.container.getInsets();
        int j3 = i * j;
        int k3 = i3 / j3;
        if (j % j3 != 0) {
            ++k3;
        }
        int l3 = k1 + l1 + j * k + (j - 1) * i1;
        int i4 = i2 + j2 + i * l + (i - 1) * j1;
        boolean flag = componentorientation.isLeftToRight();
        boolean flag1 = componentorientation.isHorizontal();
        int j5 = 0;
        while (j5 < i3) {
            int i5;
            int l4;
            int k4;
            int j4;
            if (flag) {
                if (flag1) {
                    j4 = j5 / j3;
                    k4 = 0;
                    l4 = j5 % j3 / j;
                    i5 = j5 % j;
                } else {
                    j4 = 0;
                    k4 = j5 / j3;
                    l4 = j5 % i;
                    i5 = j5 % j3 / i;
                }
            } else if (flag1) {
                j4 = j5 / j3;
                k4 = 0;
                l4 = j5 % j3 / j;
                i5 = j - j5 % j - 1;
            } else {
                j4 = 0;
                k4 = k3 - j5 / j3 - 1;
                l4 = j5 % i;
                i5 = j - j5 % j3 / i - 1;
            }
            int k5 = insets.left + k4 * l3 + k1 + i5 * k + i5 * i1;
            int l5 = insets.top + j4 * i4 + j2 + l4 * l + l4 * j1;
            Component component = acomponent[j5];
            double d1 = this.fixedWidth[j5];
            double d2 = this.fixedHeight[j5];
            double d3 = this.scaledWidth[j5];
            double d4 = this.scaledHeight[j5];
            int i6 = (int)(d1 + d3 * d);
            int j6 = (int)(d2 + d4 * d);
            int k6 = k5;
            switch (k2) {
                case 2: {
                    break;
                }
                case 0: {
                    k6 += (k - i6) / 2;
                    break;
                }
                case 4: {
                    k6 += k - i6;
                    break;
                }
                case 10: {
                    if (flag) break;
                    k6 += k - i6;
                    break;
                }
                case 11: {
                    if (!flag) break;
                    k6 += k - i6;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid horizontal alignment: " + k2));
                }
            }
            int l6 = l5;
            switch (l2) {
                case 0: {
                    l6 += (l - j6) / 2;
                    break;
                }
                case 3: {
                    l6 += l - j6;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid vertical alignment: " + l2));
                }
                case 1: 
            }
            component.setBounds(k6, l6, i6, j6);
            ++j5;
        }
    }
}

