/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org2.mozilla.javascript.Kit;
import org2.mozilla.javascript.tools.debugger.ContextWindow;
import org2.mozilla.javascript.tools.debugger.Dim;
import org2.mozilla.javascript.tools.debugger.EvalWindow;
import org2.mozilla.javascript.tools.debugger.FileTextArea;
import org2.mozilla.javascript.tools.debugger.FileWindow;
import org2.mozilla.javascript.tools.debugger.FindFunction;
import org2.mozilla.javascript.tools.debugger.GuiCallback;
import org2.mozilla.javascript.tools.debugger.JSInternalConsole;
import org2.mozilla.javascript.tools.debugger.Menubar;
import org2.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org2.mozilla.javascript.tools.debugger.MoreWindows;
import org2.mozilla.javascript.tools.debugger.RunProxy;

class SwingGui
extends JFrame
implements GuiCallback {
    static final long serialVersionUID = -8217029773456711621L;
    Dim dim;
    Runnable exitAction;
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    Hashtable toplevels = new Hashtable();
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    JFileChooser dlg;
    private static EventQueue awtEventQueue;

    SwingGui(Dim dim, String title) {
        super(title);
        SwingGui.initAllFontSon9();
        this.dim = dim;
        this.init();
    }

    public static void initAllFontSon9() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Font f1 = new Font("SimSun", 0, 12);
        Font f2 = new Font("SimSun", 1, 12);
        SwingGui.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void addTopLevel(String key, JFrame frame) {
        if (frame != this) {
            this.toplevels.put(key, frame);
        }
    }

    void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        JButton button;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        boolean count = false;
        JButton focusButton = button = (breakButton = new JButton("\u4e2d\u65ad/\u6682\u505c"));
        button.setToolTipText("\u4e2d\u65ad/\u6682\u505c\u8fd0\u884c");
        button.setActionCommand("Break");
        button.addActionListener(this.menubar);
        button.setEnabled(true);
        button = goButton = new JButton("\u8fd0\u884c");
        button.setToolTipText("\u8fd0\u884c\u76f4\u81f3\u65ad\u70b9 (F5)");
        button.setActionCommand("Go");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button = stepIntoButton = new JButton("\u5355\u6b65\u8fdb\u5165");
        button.setToolTipText("\u5355\u6b65\u8fd0\u884c\uff0c\u6216\u8fdb\u5165\u51fd\u6570 (F11)");
        button.setActionCommand("Step Into");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button = stepOverButton = new JButton("\u5355\u6b65\u8fd0\u884c");
        button.setToolTipText("\u5355\u6b65\u8fd0\u884c\uff0c\u6216\u51fd\u6570\u4f5c\u4e3a\u4e00\u4e2a\u8bed\u53e5\u8fd0\u884c (F7)");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button = stepOutButton = new JButton("\u5355\u6b65\u8df3\u51fa");
        button.setToolTipText("\u6267\u884c\u76f4\u5230\u5f53\u524d\u51fd\u6570\u7ed3\u675f (F8)");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("\u811a\u672c\u63a7\u5236\u53f0 JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split1, 0.66);
        contentPane.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        contentPane.add((Component)this.statusBar, "South");
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String n = f.getName();
                int i = n.lastIndexOf(46);
                return i > 0 && i < n.length() - 1 && (ext = n.substring(i + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        try {
            this.dlg = new JFileChooser();
            this.dlg.addChoosableFileFilter(filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingGui.this.exit();
            }
        });
    }

    void exit() {
        if (this.exitAction != null) {
            SwingUtilities.invokeLater(this.exitAction);
        }
        this.dim.setReturnValue(5);
    }

    FileWindow getFileWindow(String url) {
        if (url == null || url.equals("<stdin>")) {
            return null;
        }
        return (FileWindow)this.fileWindows.get(url);
    }

    static String getShortName(String url) {
        int lastSlash = url.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = url.lastIndexOf(92);
        }
        String shortName = url;
        if (lastSlash >= 0 && lastSlash + 1 < url.length()) {
            shortName = url.substring(lastSlash + 1);
        }
        return shortName;
    }

    void removeWindow(FileWindow w) {
        this.fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count - 1);
        String name = SwingGui.getShortName(w.getUrl());
        int i = 5;
        while (i < count) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i);
            if (item != null && (text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) {
                windowMenu.remove(item);
                if (count == 6) {
                    windowMenu.remove(4);
                    break;
                }
                int j = i - 4;
                while (i < count - 1) {
                    JMenuItem thisItem = windowMenu.getItem(i);
                    if (thisItem != null) {
                        text = thisItem.getText();
                        if (text.equals("More Windows...")) break;
                        pos = text.indexOf(32);
                        thisItem.setText(String.valueOf((char)(48 + j)) + " " + text.substring(pos + 1));
                        thisItem.setMnemonic(48 + j);
                        ++j;
                    }
                    ++i;
                }
                if (count - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
                windowMenu.remove(lastItem);
                break;
            }
            ++i;
        }
        windowMenu.revalidate();
    }

    void showStopLine(Dim.StackFrame frame) {
        String sourceName = frame.getUrl();
        if (sourceName == null || sourceName.equals("<stdin>")) {
            if (this.console.isVisible()) {
                this.console.show();
            }
        } else {
            int lineNumber = frame.getLineNumber();
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                this.setFilePosition(w, lineNumber);
            } else {
                Dim.SourceInfo si = frame.sourceInfo();
                this.createFileWindow(si, lineNumber);
            }
        }
    }

    void createFileWindow(Dim.SourceInfo sourceInfo, int line) {
        boolean activate = true;
        String url = sourceInfo.url();
        FileWindow w = new FileWindow(this, sourceInfo);
        this.fileWindows.put(url, w);
        if (line != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            try {
                w.setPosition(w.textArea.getLineStartOffset(line - 1));
            }
            catch (BadLocationException exc) {
                try {
                    w.setPosition(w.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException ee) {
                    w.setPosition(-1);
                }
            }
        }
        this.desk.add(w);
        if (line != -1) {
            this.currentWindow = w;
        }
        this.menubar.addFile(url);
        w.setVisible(true);
        if (activate) {
            try {
                w.setMaximum(true);
                w.setSelected(true);
                w.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setFilePosition(FileWindow w, int line) {
        boolean activate = true;
        FileTextArea ta = w.textArea;
        try {
            if (line == -1) {
                w.setPosition(-1);
                if (this.currentWindow == w) {
                    this.currentWindow = null;
                }
            } else {
                int loc = ta.getLineStartOffset(line - 1);
                if (this.currentWindow != null && this.currentWindow != w) {
                    this.currentWindow.setPosition(-1);
                }
                w.setPosition(loc);
                this.currentWindow = w;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (activate) {
            if (w.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(w);
            }
            this.desk.getDesktopManager().activateFrame(w);
            try {
                w.show();
                w.toFront();
                w.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateSourceText(Dim.SourceInfo sourceInfo) {
        RunProxy proxy = new RunProxy(this, 3);
        proxy.sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(proxy);
    }

    public void enterInterrupt(Dim.StackFrame lastFrame, String threadTitle, String alertMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(lastFrame, threadTitle, alertMessage);
        } else {
            RunProxy proxy = new RunProxy(this, 4);
            proxy.lastFrame = lastFrame;
            proxy.threadTitle = threadTitle;
            proxy.alertMessage = alertMessage;
            SwingUtilities.invokeLater(proxy);
        }
    }

    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent event;
        EventQueue queue = awtEventQueue;
        if (queue == null) {
            awtEventQueue = queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((event = queue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else {
            Object source = event.getSource();
            if (source instanceof Component) {
                Component comp = (Component)source;
                comp.dispatchEvent(event);
            } else if (source instanceof MenuComponent) {
                ((MenuComponent)source).dispatchEvent(event);
            }
        }
    }

    void enterInterruptImpl(Dim.StackFrame lastFrame, String threadTitle, String alertMessage) {
        this.statusBar.setText("Thread: " + threadTitle);
        this.showStopLine(lastFrame);
        if (alertMessage != null) {
            MessageDialogWrapper.showMessageDialog(this, alertMessage, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        Dim.ContextData contextData = lastFrame.contextData();
        JComboBox ctx = this.context.context;
        Vector toolTips = this.context.toolTips;
        this.context.disableUpdate();
        int frameCount = contextData.frameCount();
        ctx.removeAllItems();
        ctx.setSelectedItem(null);
        toolTips.removeAllElements();
        int i = 0;
        while (i < frameCount) {
            Dim.StackFrame frame = contextData.getFrame(i);
            String url = frame.getUrl();
            int lineNumber = frame.getLineNumber();
            String shortName = url;
            if (url.length() > 20) {
                shortName = "..." + url.substring(url.length() - 17);
            }
            String location = "\"" + shortName + "\", line " + lineNumber;
            ctx.insertItemAt(location, i);
            location = "\"" + url + "\", line " + lineNumber;
            toolTips.addElement(location);
            ++i;
        }
        this.context.enableUpdate();
        ctx.setSelectedIndex(0);
        ctx.setMinimumSize(new Dimension(50, ctx.getMinimumSize().height));
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    String chooseFile(String title) {
        int returnVal;
        this.dlg.setDialogTitle(title);
        File CWD = null;
        String dir = "/";
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            this.dlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String result = this.dlg.getSelectedFile().getCanonicalPath();
                CWD = this.dlg.getSelectedFile().getParentFile();
                return result;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                return frames[i];
            }
            ++i;
        }
        return frames[frames.length - 1];
    }

    void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        int returnValue = -1;
        if (cmd.equals("\u526a\u5207") || cmd.equals("\u590d\u5236") || cmd.equals("\u7c98\u8d34")) {
            JInternalFrame f = this.getSelectedFrame();
            if (f != null && f instanceof ActionListener) {
                ((ActionListener)((Object)f)).actionPerformed(e);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue = 2;
        } else if (cmd.equals("Go")) {
            returnValue = 3;
        } else if (cmd.equals("Break")) {
            this.dim.breakFlag = true;
        } else if (cmd.equals("Exit")) {
            this.exit();
        } else if (cmd.equals("Open")) {
            String text;
            String fileName = this.chooseFile("\u9009\u62e9\u6253\u5f00\u7f16\u8bd1\u7684\u6587\u4ef6");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 1);
                proxy.fileName = fileName;
                proxy.text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("Load")) {
            String text;
            String fileName = this.chooseFile("\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6587\u4ef6");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 2);
                proxy.fileName = fileName;
                proxy.text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("More Windows...")) {
            MoreWindows dlg = new MoreWindows(this, this.fileWindows, "Window", "Files");
            dlg.showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            if (cmd.equals("Go to function...")) {
                FindFunction dlg = new FindFunction(this, "Go to function", "Function");
                dlg.showDialog(this);
            } else if (cmd.equals("Tile")) {
                JInternalFrame[] frames = this.desk.getAllFrames();
                int count = frames.length;
                int cols = (int)Math.sqrt(count);
                int rows = cols;
                if (rows * cols < count && rows * ++cols < count) {
                    ++rows;
                }
                Dimension size = this.desk.getSize();
                int w = size.width / cols;
                int h = size.height / rows;
                int x = 0;
                int y = 0;
                int i2 = 0;
                while (i2 < rows) {
                    int j = 0;
                    while (j < cols) {
                        int index = i2 * cols + j;
                        if (index >= frames.length) break;
                        JInternalFrame f = frames[index];
                        try {
                            f.setIcon(false);
                            f.setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                        x += w;
                        ++j;
                    }
                    y += h;
                    x = 0;
                    ++i2;
                }
            } else if (cmd.equals("\u5c42\u53e0")) {
                JInternalFrame[] frames = this.desk.getAllFrames();
                int count = frames.length;
                int y = 0;
                int x = 0;
                int h = this.desk.getHeight();
                int d = h / count;
                if (d > 30) {
                    d = 30;
                }
                int i = count - 1;
                while (i >= 0) {
                    JInternalFrame f = frames[i];
                    try {
                        f.setIcon(false);
                        f.setMaximum(false);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                    Dimension dimen = f.getPreferredSize();
                    int w = dimen.width;
                    h = dimen.height;
                    this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                    --i;
                    x += d;
                    y += d;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w = obj;
                    try {
                        if (w.isIcon()) {
                            w.setIcon(false);
                        }
                        w.setVisible(true);
                        w.moveToFront();
                        w.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (returnValue != -1) {
            this.updateEnabled(false);
            this.dim.setReturnValue(returnValue);
        }
    }

    private void updateEnabled(boolean interrupted) {
        ((Menubar)this.getJMenuBar()).updateEnabled(interrupted);
        int ci = 0;
        int cc = this.toolBar.getComponentCount();
        while (ci < cc) {
            boolean enableButton = ci == 0 ? !interrupted : interrupted;
            this.toolBar.getComponent(ci).setEnabled(enableButton);
            ++ci;
        }
        if (interrupted) {
            this.toolBar.setEnabled(true);
            int state = this.getExtendedState();
            if (state == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.context.enable();
        } else {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            this.context.disable();
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    String readFile(String fileName) {
        String text;
        try {
            FileReader r = new FileReader(fileName);
            try {
                text = Kit.readReader(r);
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (IOException ex) {
            MessageDialogWrapper.showMessageDialog(this, ex.getMessage(), "Error reading " + fileName, 0);
            text = null;
        }
        return text;
    }
}

