/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.io.InputStream;
import java.io.PrintStream;
import org2.mozilla.javascript.ContextFactory;
import org2.mozilla.javascript.Kit;
import org2.mozilla.javascript.Scriptable;
import org2.mozilla.javascript.tools.debugger.Dim;
import org2.mozilla.javascript.tools.debugger.ScopeProvider;
import org2.mozilla.javascript.tools.debugger.SwingGui;

public class Main {
    Dim dim = new Dim();
    SwingGui debugGui;

    public Main(String title) {
        this.debugGui = new SwingGui(this.dim, title);
        this.dim.callback = this.debugGui;
        this.setExitAction(new IProxy(1));
    }

    public Object getOutput() {
        return this.debugGui.context.output;
    }

    public void doBreak() {
        this.dim.breakFlag = true;
    }

    public void setBreakOnExceptions(boolean value) {
        this.dim.breakOnExceptions = value;
        this.debugGui.menubar.breakOnExceptions.setSelected(value);
    }

    public void setBreakOnEnter(boolean value) {
        this.dim.breakOnEnter = value;
        this.debugGui.menubar.breakOnEnter.setSelected(value);
    }

    public void setBreakOnReturn(boolean value) {
        this.dim.breakOnReturn = value;
        this.debugGui.menubar.breakOnReturn.setSelected(value);
    }

    public void clearAllBreakpoints() {
        this.dim.clearAllBreakpoints();
    }

    public void go() {
        this.dim.go();
    }

    public void setScopeProvider(ScopeProvider p) {
        this.dim.scopeProvider = p;
    }

    public void setExitAction(Runnable r) {
        this.debugGui.exitAction = r;
    }

    public InputStream getIn() {
        return this.debugGui.console.getIn();
    }

    public PrintStream getOut() {
        return this.debugGui.console.getOut();
    }

    public PrintStream getErr() {
        return this.debugGui.console.getErr();
    }

    public void pack() {
        this.debugGui.pack();
    }

    public void setSize(int w, int h) {
        this.debugGui.setSize(w, h);
    }

    public void setSize(Dimension dimension) {
        this.debugGui.setSize(dimension.width, dimension.height);
    }

    public void setVisible(boolean flag) {
        this.debugGui.setVisible(flag);
    }

    public boolean isVisible() {
        return this.debugGui.isVisible();
    }

    public void dispose() {
        this.dim = null;
        this.debugGui.dispose();
    }

    public void attachTo(ContextFactory factory) {
        this.dim.attachTo(factory);
    }

    public static void main(String[] args) {
        Main main = new Main("Rhino JavaScript Debugger");
        main.doBreak();
        main.setExitAction(new IProxy(1));
        System.setIn(main.getIn());
        System.setOut(main.getOut());
        System.setErr(main.getErr());
        main.attachTo(org2.mozilla.javascript.tools.shell.Main.shellContextFactory);
        main.setScopeProvider(new IProxy(2));
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
        org2.mozilla.javascript.tools.shell.Main.exec(args);
    }

    public static void mainEmbedded(String title) {
        IProxy scopeProvider = new IProxy(2);
        Main.mainEmbedded(ContextFactory.getGlobal(), scopeProvider, title);
    }

    public static void mainEmbedded(ContextFactory factory, ScopeProvider scopeProvider, String title) {
        if (title == null) {
            title = "Rhino JavaScript Debugger (embedded usage)";
        }
        Main main = new Main(title);
        main.doBreak();
        main.setExitAction(new IProxy(1));
        main.attachTo(factory);
        main.setScopeProvider(scopeProvider);
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
    }

    private static class IProxy
    implements Runnable,
    ScopeProvider {
        static final int EXIT_ACTION = 1;
        static final int SCOPE_PROVIDER = 2;
        private final int type;

        IProxy(int type) {
            this.type = type;
        }

        public void run() {
            if (this.type != 1) {
                Kit.codeBug();
            }
            System.exit(0);
        }

        public Scriptable getScope() {
            if (this.type != 2) {
                Kit.codeBug();
            }
            return org2.mozilla.javascript.tools.shell.Main.getScope();
        }
    }
}

