/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.optimizer;

import org2.mozilla.javascript.FunctionNode;
import org2.mozilla.javascript.Kit;
import org2.mozilla.javascript.Node;
import org2.mozilla.javascript.ScriptOrFnNode;

final class OptFunctionNode {
    FunctionNode fnode;
    private boolean[] numberVarFlags;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode fnode) {
        this.fnode = fnode;
        fnode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFn, int i) {
        FunctionNode fnode = scriptOrFn.getFunctionNode(i);
        return (OptFunctionNode)fnode.getCompilerData();
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFn) {
        return (OptFunctionNode)scriptOrFn.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int directTargetIndex) {
        if (directTargetIndex < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = directTargetIndex;
    }

    void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.fnode.getParamAndVarCount();
    }

    boolean isParameter(int varIndex) {
        return varIndex < this.fnode.getParamCount();
    }

    boolean isNumberVar(int varIndex) {
        if ((varIndex -= this.fnode.getParamCount()) >= 0 && this.numberVarFlags != null) {
            return this.numberVarFlags[varIndex];
        }
        return false;
    }

    void setIsNumberVar(int varIndex) {
        if ((varIndex -= this.fnode.getParamCount()) < 0) {
            Kit.codeBug();
        }
        if (this.numberVarFlags == null) {
            int size = this.fnode.getParamAndVarCount() - this.fnode.getParamCount();
            this.numberVarFlags = new boolean[size];
        }
        this.numberVarFlags[varIndex] = true;
    }

    int getVarIndex(Node n) {
        int index = n.getIntProp(7, -1);
        if (index == -1) {
            String name;
            int type = n.getType();
            if (type == 54) {
                name = n.getString();
            } else if (type == 55) {
                name = n.getFirstChild().getString();
            } else {
                throw Kit.codeBug();
            }
            index = this.fnode.getParamOrVarIndex(name);
            if (index < 0) {
                throw Kit.codeBug();
            }
            n.putIntProp(7, index);
        }
        return index;
    }
}

