/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org2.mozilla.javascript.Node;
import org2.mozilla.javascript.ObjArray;
import org2.mozilla.javascript.ObjToIntMap;
import org2.mozilla.javascript.optimizer.DataFlowBitSet;
import org2.mozilla.javascript.optimizer.OptFunctionNode;

class Block {
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;
    static final boolean DEBUG = false;
    private static int debug_blockCount;

    Block(int startNodeIndex, int endNodeIndex) {
        this.itsStartNodeIndex = startNodeIndex;
        this.itsEndNodeIndex = endNodeIndex;
    }

    static void runFlowAnalyzes(OptFunctionNode fn, Node[] statementNodes) {
        int paramCount = fn.fnode.getParamCount();
        int varCount = fn.fnode.getParamAndVarCount();
        int[] varTypes = new int[varCount];
        int i = 0;
        while (i != paramCount) {
            varTypes[i] = 3;
            ++i;
        }
        i = paramCount;
        while (i != varCount) {
            varTypes[i] = 0;
            ++i;
        }
        Block[] theBlocks = Block.buildBlocks(statementNodes);
        Block.reachingDefDataFlow(fn, statementNodes, theBlocks, varTypes);
        Block.typeFlow(fn, statementNodes, theBlocks, varTypes);
        int i2 = paramCount;
        while (i2 != varCount) {
            if (varTypes[i2] == 1) {
                fn.setIsNumberVar(i2);
            }
            ++i2;
        }
    }

    private static Block[] buildBlocks(Node[] statementNodes) {
        FatBlock fb;
        Hashtable<Node, FatBlock> theTargetBlocks = new Hashtable<Node, FatBlock>();
        ObjArray theBlocks = new ObjArray();
        int beginNodeIndex = 0;
        int i = 0;
        while (i < statementNodes.length) {
            switch (statementNodes[i].getType()) {
                case 127: {
                    if (i == beginNodeIndex) break;
                    fb = Block.newFatBlock(beginNodeIndex, i - 1);
                    if (statementNodes[beginNodeIndex].getType() == 127) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    fb = Block.newFatBlock(beginNodeIndex, i);
                    if (statementNodes[beginNodeIndex].getType() == 127) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i + 1;
                }
            }
            ++i;
        }
        if (beginNodeIndex != statementNodes.length) {
            FatBlock fb2 = Block.newFatBlock(beginNodeIndex, statementNodes.length - 1);
            if (statementNodes[beginNodeIndex].getType() == 127) {
                theTargetBlocks.put(statementNodes[beginNodeIndex], fb2);
            }
            theBlocks.add(fb2);
        }
        i = 0;
        while (i < theBlocks.size()) {
            fb = (FatBlock)theBlocks.get(i);
            Node blockEndNode = statementNodes[fb.realBlock.itsEndNodeIndex];
            int blockEndNodeType = blockEndNode.getType();
            if (blockEndNodeType != 5 && i < theBlocks.size() - 1) {
                FatBlock fallThruTarget = (FatBlock)theBlocks.get(i + 1);
                fb.addSuccessor(fallThruTarget);
                fallThruTarget.addPredecessor(fb);
            }
            if (blockEndNodeType == 7 || blockEndNodeType == 6 || blockEndNodeType == 5) {
                Node target = ((Node.Jump)blockEndNode).target;
                FatBlock branchTargetBlock = (FatBlock)theTargetBlocks.get(target);
                target.putProp(6, branchTargetBlock.realBlock);
                fb.addSuccessor(branchTargetBlock);
                branchTargetBlock.addPredecessor(fb);
            }
            ++i;
        }
        Block[] result = new Block[theBlocks.size()];
        int i2 = 0;
        while (i2 < theBlocks.size()) {
            FatBlock fb3 = (FatBlock)theBlocks.get(i2);
            Block b = fb3.realBlock;
            b.itsSuccessors = fb3.getSuccessors();
            b.itsPredecessors = fb3.getPredecessors();
            b.itsBlockID = i2;
            result[i2] = b;
            ++i2;
        }
        return result;
    }

    private static FatBlock newFatBlock(int startNodeIndex, int endNodeIndex) {
        FatBlock fb = new FatBlock();
        fb.realBlock = new Block(startNodeIndex, endNodeIndex);
        return fb;
    }

    private static String toString(Block[] blockList, Node[] statementNodes) {
        return null;
    }

    private static void reachingDefDataFlow(OptFunctionNode fn, Node[] statementNodes, Block[] theBlocks, int[] varTypes) {
        int i = 0;
        while (i < theBlocks.length) {
            theBlocks[i].initLiveOnEntrySets(fn, statementNodes);
            ++i;
        }
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = theBlocks.length - 1;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] pred;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doReachedUseDataFlow() && (pred = theBlocks[vIndex].itsPredecessors) != null) {
                    int i2 = 0;
                    while (i2 < pred.length) {
                        int index = pred[i2].itsBlockID;
                        visit[index] = true;
                        needRescan |= index > vIndex;
                        ++i2;
                    }
                }
            }
            if (vIndex == 0) {
                if (!needRescan) break;
                vIndex = theBlocks.length - 1;
                needRescan = false;
                continue;
            }
            --vIndex;
        }
        theBlocks[0].markAnyTypeVariables(varTypes);
    }

    private static void typeFlow(OptFunctionNode fn, Node[] statementNodes, Block[] theBlocks, int[] varTypes) {
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = 0;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] succ;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doTypeFlow(fn, statementNodes, varTypes) && (succ = theBlocks[vIndex].itsSuccessors) != null) {
                    int i = 0;
                    while (i < succ.length) {
                        int index = succ[i].itsBlockID;
                        visit[index] = true;
                        needRescan |= index < vIndex;
                        ++i;
                    }
                }
            }
            if (vIndex == theBlocks.length - 1) {
                if (!needRescan) break;
                vIndex = 0;
                needRescan = false;
                continue;
            }
            ++vIndex;
        }
    }

    private static boolean assignType(int[] varTypes, int index, int type) {
        int n = index;
        varTypes[n] = varTypes[n] | type;
        return type != varTypes[n];
    }

    private void markAnyTypeVariables(int[] varTypes) {
        int i = 0;
        while (i != varTypes.length) {
            if (this.itsLiveOnEntrySet.test(i)) {
                Block.assignType(varTypes, i, 3);
            }
            ++i;
        }
    }

    private void lookForVariableAccess(OptFunctionNode fn, Node n) {
        switch (n.getType()) {
            case 102: 
            case 103: {
                Node child = n.getFirstChild();
                if (child.getType() != 54) break;
                int varIndex = fn.getVarIndex(child);
                if (!this.itsNotDefSet.test(varIndex)) {
                    this.itsUseBeforeDefSet.set(varIndex);
                }
                this.itsNotDefSet.set(varIndex);
                break;
            }
            case 55: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                this.lookForVariableAccess(fn, rhs);
                this.itsNotDefSet.set(fn.getVarIndex(n));
                break;
            }
            case 54: {
                int varIndex = fn.getVarIndex(n);
                if (this.itsNotDefSet.test(varIndex)) break;
                this.itsUseBeforeDefSet.set(varIndex);
                break;
            }
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.lookForVariableAccess(fn, child);
                    child = child.getNext();
                }
                break block0;
            }
        }
    }

    private void initLiveOnEntrySets(OptFunctionNode fn, Node[] statementNodes) {
        int listLength = fn.getVarCount();
        this.itsUseBeforeDefSet = new DataFlowBitSet(listLength);
        this.itsNotDefSet = new DataFlowBitSet(listLength);
        this.itsLiveOnEntrySet = new DataFlowBitSet(listLength);
        this.itsLiveOnExitSet = new DataFlowBitSet(listLength);
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = statementNodes[i];
            this.lookForVariableAccess(fn, n);
            ++i;
        }
        this.itsNotDefSet.not();
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            int i = 0;
            while (i < this.itsSuccessors.length) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
                ++i;
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private static int findExpressionType(OptFunctionNode fn, Node n, int[] varTypes) {
        switch (n.getType()) {
            case 39: {
                return 1;
            }
            case 30: 
            case 37: 
            case 68: {
                return 3;
            }
            case 35: {
                return 3;
            }
            case 54: {
                return varTypes[fn.getVarIndex(n)];
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 102: 
            case 103: {
                return 1;
            }
            case 21: {
                Node child = n.getFirstChild();
                int lType = Block.findExpressionType(fn, child, varTypes);
                int rType = Block.findExpressionType(fn, child.getNext(), varTypes);
                return lType | rType;
            }
        }
        Node child = n.getFirstChild();
        if (child == null) {
            return 3;
        }
        int result = 0;
        while (child != null) {
            result |= Block.findExpressionType(fn, child, varTypes);
            child = child.getNext();
        }
        return result;
    }

    private static boolean findDefPoints(OptFunctionNode fn, Node n, int[] varTypes) {
        boolean result = false;
        Node child = n.getFirstChild();
        switch (n.getType()) {
            default: {
                while (child != null) {
                    result |= Block.findDefPoints(fn, child, varTypes);
                    child = child.getNext();
                }
                break;
            }
            case 102: 
            case 103: {
                if (child.getType() != 54) break;
                int i = fn.getVarIndex(child);
                result |= Block.assignType(varTypes, i, 1);
                break;
            }
            case 34: 
            case 135: {
                if (child.getType() == 54) {
                    int i = fn.getVarIndex(child);
                    Block.assignType(varTypes, i, 3);
                }
                while (child != null) {
                    result |= Block.findDefPoints(fn, child, varTypes);
                    child = child.getNext();
                }
                break;
            }
            case 55: {
                Node rValue = child.getNext();
                int theType = Block.findExpressionType(fn, rValue, varTypes);
                int i = fn.getVarIndex(n);
                result |= Block.assignType(varTypes, i, theType);
            }
        }
        return result;
    }

    private boolean doTypeFlow(OptFunctionNode fn, Node[] statementNodes, int[] varTypes) {
        boolean changed = false;
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = statementNodes[i];
            if (n != null) {
                changed |= Block.findDefPoints(fn, n, varTypes);
            }
            ++i;
        }
        return changed;
    }

    private boolean isLiveOnEntry(int index) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(index);
    }

    private void printLiveOnEntrySet(OptFunctionNode fn) {
    }

    private static class FatBlock {
        private ObjToIntMap successors = new ObjToIntMap();
        private ObjToIntMap predecessors = new ObjToIntMap();
        Block realBlock;

        private FatBlock() {
        }

        private static Block[] reduceToArray(ObjToIntMap map) {
            Block[] result = null;
            if (!map.isEmpty()) {
                result = new Block[map.size()];
                int i = 0;
                ObjToIntMap.Iterator iter = map.newIterator();
                iter.start();
                while (!iter.done()) {
                    FatBlock fb = (FatBlock)iter.getKey();
                    result[i++] = fb.realBlock;
                    iter.next();
                }
            }
            return result;
        }

        void addSuccessor(FatBlock b) {
            this.successors.put(b, 0);
        }

        void addPredecessor(FatBlock b) {
            this.predecessors.put(b, 0);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }
    }
}

