/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class PrintBeanInfo {
    private PrintBeanInfo() {
    }

    public static void print(Class c) {
        try {
            System.out.println("Class: " + c.getName());
            System.out.println("========================================================================");
            BeanInfo bi = Introspector.getBeanInfo(c, c.getSuperclass());
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            int i = 0;
            while (i < pd.length) {
                System.out.println("Property: " + pd[i].getDisplayName());
                System.out.println("---------------------------------------------------------------------");
                System.out.println(" ( " + pd[i].getShortDescription() + ")");
                if (pd[i] instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)pd[i];
                    System.out.println("  - idx-type   : " + id.getIndexedPropertyType());
                    System.out.println("  - idx-read   : " + id.getIndexedReadMethod());
                    System.out.println("  - idx-write  : " + id.getIndexedWriteMethod());
                } else {
                    System.out.println("  - type       : " + pd[i].getPropertyType());
                    System.out.println("  - read       : " + pd[i].getReadMethod());
                    System.out.println("  - write      : " + pd[i].getWriteMethod());
                }
                System.out.println("  - bound      : " + pd[i].isBound());
                System.out.println("  - constrained: " + pd[i].isConstrained());
                ++i;
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            PrintBeanInfo.print(Class.forName(args[i]));
            ++i;
        }
    }
}

